<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceMatrixNodeRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:PlaceMatrixNodeRequest
 * @subpackage Structs
 */
class PlaceMatrixNodeRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The ToParentCustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ToParentCustomerID;
    /**
     * The ToParentMatrixID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ToParentMatrixID;
    /**
     * The Placement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Placement;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reason;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * The ToParentCustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToParentCustomerKey;
    /**
     * The ToParentMatrixKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToParentMatrixKey;
    /**
     * Constructor method for PlaceMatrixNodeRequest
     * @uses PlaceMatrixNodeRequest::setCustomerID()
     * @uses PlaceMatrixNodeRequest::setToParentCustomerID()
     * @uses PlaceMatrixNodeRequest::setToParentMatrixID()
     * @uses PlaceMatrixNodeRequest::setPlacement()
     * @uses PlaceMatrixNodeRequest::setReason()
     * @uses PlaceMatrixNodeRequest::setCustomerKey()
     * @uses PlaceMatrixNodeRequest::setToParentCustomerKey()
     * @uses PlaceMatrixNodeRequest::setToParentMatrixKey()
     * @param int $customerID
     * @param int $toParentCustomerID
     * @param int $toParentMatrixID
     * @param int $placement
     * @param string $reason
     * @param string $customerKey
     * @param string $toParentCustomerKey
     * @param string $toParentMatrixKey
     */
    public function __construct($customerID = null, $toParentCustomerID = null, $toParentMatrixID = null, $placement = null, $reason = null, $customerKey = null, $toParentCustomerKey = null, $toParentMatrixKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setToParentCustomerID($toParentCustomerID)
            ->setToParentMatrixID($toParentMatrixID)
            ->setPlacement($placement)
            ->setReason($reason)
            ->setCustomerKey($customerKey)
            ->setToParentCustomerKey($toParentCustomerKey)
            ->setToParentMatrixKey($toParentMatrixKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\PlaceMatrixNodeRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get ToParentCustomerID value
     * @return int
     */
    public function getToParentCustomerID()
    {
        return $this->ToParentCustomerID;
    }
    /**
     * Set ToParentCustomerID value
     * @param int $toParentCustomerID
     * @return \StructType\PlaceMatrixNodeRequest
     */
    public function setToParentCustomerID($toParentCustomerID = null)
    {
        // validation for constraint: int
        if (!is_null($toParentCustomerID) && !is_numeric($toParentCustomerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($toParentCustomerID)), __LINE__);
        }
        $this->ToParentCustomerID = $toParentCustomerID;
        return $this;
    }
    /**
     * Get ToParentMatrixID value
     * @return int
     */
    public function getToParentMatrixID()
    {
        return $this->ToParentMatrixID;
    }
    /**
     * Set ToParentMatrixID value
     * @param int $toParentMatrixID
     * @return \StructType\PlaceMatrixNodeRequest
     */
    public function setToParentMatrixID($toParentMatrixID = null)
    {
        // validation for constraint: int
        if (!is_null($toParentMatrixID) && !is_numeric($toParentMatrixID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($toParentMatrixID)), __LINE__);
        }
        $this->ToParentMatrixID = $toParentMatrixID;
        return $this;
    }
    /**
     * Get Placement value
     * @return int
     */
    public function getPlacement()
    {
        return $this->Placement;
    }
    /**
     * Set Placement value
     * @param int $placement
     * @return \StructType\PlaceMatrixNodeRequest
     */
    public function setPlacement($placement = null)
    {
        // validation for constraint: int
        if (!is_null($placement) && !is_numeric($placement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($placement)), __LINE__);
        }
        $this->Placement = $placement;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \StructType\PlaceMatrixNodeRequest
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\PlaceMatrixNodeRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Get ToParentCustomerKey value
     * @return string|null
     */
    public function getToParentCustomerKey()
    {
        return $this->ToParentCustomerKey;
    }
    /**
     * Set ToParentCustomerKey value
     * @param string $toParentCustomerKey
     * @return \StructType\PlaceMatrixNodeRequest
     */
    public function setToParentCustomerKey($toParentCustomerKey = null)
    {
        // validation for constraint: string
        if (!is_null($toParentCustomerKey) && !is_string($toParentCustomerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toParentCustomerKey)), __LINE__);
        }
        $this->ToParentCustomerKey = $toParentCustomerKey;
        return $this;
    }
    /**
     * Get ToParentMatrixKey value
     * @return string|null
     */
    public function getToParentMatrixKey()
    {
        return $this->ToParentMatrixKey;
    }
    /**
     * Set ToParentMatrixKey value
     * @param string $toParentMatrixKey
     * @return \StructType\PlaceMatrixNodeRequest
     */
    public function setToParentMatrixKey($toParentMatrixKey = null)
    {
        // validation for constraint: string
        if (!is_null($toParentMatrixKey) && !is_string($toParentMatrixKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toParentMatrixKey)), __LINE__);
        }
        $this->ToParentMatrixKey = $toParentMatrixKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlaceMatrixNodeRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
