<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentResponse StructType
 * @subpackage Structs
 */
class PaymentResponse extends AbstractStructBase
{
    /**
     * The PaymentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentID;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The PaymentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentType;
    /**
     * The PaymentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentDate;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OrderID;
    /**
     * The CreditCardType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CreditCardType;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The BillingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingName;
    /**
     * The BillingAddress1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingAddress1;
    /**
     * The BillingAddress2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingAddress2;
    /**
     * The BillingCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCity;
    /**
     * The BillingState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingState;
    /**
     * The BillingZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingZip;
    /**
     * The BillingCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCountry;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankName;
    /**
     * The Memo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The CreditCardNumberDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditCardNumberDisplay;
    /**
     * The AuthorizationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthorizationCode;
    /**
     * The CreditCardTypeDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditCardTypeDescription;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for PaymentResponse
     * @uses PaymentResponse::setPaymentID()
     * @uses PaymentResponse::setCustomerID()
     * @uses PaymentResponse::setPaymentType()
     * @uses PaymentResponse::setPaymentDate()
     * @uses PaymentResponse::setAmount()
     * @uses PaymentResponse::setOrderID()
     * @uses PaymentResponse::setCreditCardType()
     * @uses PaymentResponse::setCurrencyCode()
     * @uses PaymentResponse::setBillingName()
     * @uses PaymentResponse::setBillingAddress1()
     * @uses PaymentResponse::setBillingAddress2()
     * @uses PaymentResponse::setBillingCity()
     * @uses PaymentResponse::setBillingState()
     * @uses PaymentResponse::setBillingZip()
     * @uses PaymentResponse::setBillingCountry()
     * @uses PaymentResponse::setBankName()
     * @uses PaymentResponse::setMemo()
     * @uses PaymentResponse::setCreditCardNumberDisplay()
     * @uses PaymentResponse::setAuthorizationCode()
     * @uses PaymentResponse::setCreditCardTypeDescription()
     * @uses PaymentResponse::setOrderKey()
     * @uses PaymentResponse::setCustomerKey()
     * @param int $paymentID
     * @param int $customerID
     * @param string $paymentType
     * @param string $paymentDate
     * @param float $amount
     * @param int $orderID
     * @param int $creditCardType
     * @param string $currencyCode
     * @param string $billingName
     * @param string $billingAddress1
     * @param string $billingAddress2
     * @param string $billingCity
     * @param string $billingState
     * @param string $billingZip
     * @param string $billingCountry
     * @param string $bankName
     * @param string $memo
     * @param string $creditCardNumberDisplay
     * @param string $authorizationCode
     * @param string $creditCardTypeDescription
     * @param string $orderKey
     * @param string $customerKey
     */
    public function __construct($paymentID = null, $customerID = null, $paymentType = null, $paymentDate = null, $amount = null, $orderID = null, $creditCardType = null, $currencyCode = null, $billingName = null, $billingAddress1 = null, $billingAddress2 = null, $billingCity = null, $billingState = null, $billingZip = null, $billingCountry = null, $bankName = null, $memo = null, $creditCardNumberDisplay = null, $authorizationCode = null, $creditCardTypeDescription = null, $orderKey = null, $customerKey = null)
    {
        $this
            ->setPaymentID($paymentID)
            ->setCustomerID($customerID)
            ->setPaymentType($paymentType)
            ->setPaymentDate($paymentDate)
            ->setAmount($amount)
            ->setOrderID($orderID)
            ->setCreditCardType($creditCardType)
            ->setCurrencyCode($currencyCode)
            ->setBillingName($billingName)
            ->setBillingAddress1($billingAddress1)
            ->setBillingAddress2($billingAddress2)
            ->setBillingCity($billingCity)
            ->setBillingState($billingState)
            ->setBillingZip($billingZip)
            ->setBillingCountry($billingCountry)
            ->setBankName($bankName)
            ->setMemo($memo)
            ->setCreditCardNumberDisplay($creditCardNumberDisplay)
            ->setAuthorizationCode($authorizationCode)
            ->setCreditCardTypeDescription($creditCardTypeDescription)
            ->setOrderKey($orderKey)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get PaymentID value
     * @return int
     */
    public function getPaymentID()
    {
        return $this->PaymentID;
    }
    /**
     * Set PaymentID value
     * @param int $paymentID
     * @return \StructType\PaymentResponse
     */
    public function setPaymentID($paymentID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentID) && !is_numeric($paymentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentID)), __LINE__);
        }
        $this->PaymentID = $paymentID;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\PaymentResponse
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @uses \EnumType\PaymentType::valueIsValid()
     * @uses \EnumType\PaymentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentType
     * @return \StructType\PaymentResponse
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentType::valueIsValid($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentType, implode(', ', \EnumType\PaymentType::getValidValues())), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \StructType\PaymentResponse
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\PaymentResponse
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\PaymentResponse
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get CreditCardType value
     * @return int
     */
    public function getCreditCardType()
    {
        return $this->CreditCardType;
    }
    /**
     * Set CreditCardType value
     * @param int $creditCardType
     * @return \StructType\PaymentResponse
     */
    public function setCreditCardType($creditCardType = null)
    {
        // validation for constraint: int
        if (!is_null($creditCardType) && !is_numeric($creditCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($creditCardType)), __LINE__);
        }
        $this->CreditCardType = $creditCardType;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\PaymentResponse
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get BillingName value
     * @return string|null
     */
    public function getBillingName()
    {
        return $this->BillingName;
    }
    /**
     * Set BillingName value
     * @param string $billingName
     * @return \StructType\PaymentResponse
     */
    public function setBillingName($billingName = null)
    {
        // validation for constraint: string
        if (!is_null($billingName) && !is_string($billingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingName)), __LINE__);
        }
        $this->BillingName = $billingName;
        return $this;
    }
    /**
     * Get BillingAddress1 value
     * @return string|null
     */
    public function getBillingAddress1()
    {
        return $this->BillingAddress1;
    }
    /**
     * Set BillingAddress1 value
     * @param string $billingAddress1
     * @return \StructType\PaymentResponse
     */
    public function setBillingAddress1($billingAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($billingAddress1) && !is_string($billingAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingAddress1)), __LINE__);
        }
        $this->BillingAddress1 = $billingAddress1;
        return $this;
    }
    /**
     * Get BillingAddress2 value
     * @return string|null
     */
    public function getBillingAddress2()
    {
        return $this->BillingAddress2;
    }
    /**
     * Set BillingAddress2 value
     * @param string $billingAddress2
     * @return \StructType\PaymentResponse
     */
    public function setBillingAddress2($billingAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($billingAddress2) && !is_string($billingAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingAddress2)), __LINE__);
        }
        $this->BillingAddress2 = $billingAddress2;
        return $this;
    }
    /**
     * Get BillingCity value
     * @return string|null
     */
    public function getBillingCity()
    {
        return $this->BillingCity;
    }
    /**
     * Set BillingCity value
     * @param string $billingCity
     * @return \StructType\PaymentResponse
     */
    public function setBillingCity($billingCity = null)
    {
        // validation for constraint: string
        if (!is_null($billingCity) && !is_string($billingCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCity)), __LINE__);
        }
        $this->BillingCity = $billingCity;
        return $this;
    }
    /**
     * Get BillingState value
     * @return string|null
     */
    public function getBillingState()
    {
        return $this->BillingState;
    }
    /**
     * Set BillingState value
     * @param string $billingState
     * @return \StructType\PaymentResponse
     */
    public function setBillingState($billingState = null)
    {
        // validation for constraint: string
        if (!is_null($billingState) && !is_string($billingState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingState)), __LINE__);
        }
        $this->BillingState = $billingState;
        return $this;
    }
    /**
     * Get BillingZip value
     * @return string|null
     */
    public function getBillingZip()
    {
        return $this->BillingZip;
    }
    /**
     * Set BillingZip value
     * @param string $billingZip
     * @return \StructType\PaymentResponse
     */
    public function setBillingZip($billingZip = null)
    {
        // validation for constraint: string
        if (!is_null($billingZip) && !is_string($billingZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingZip)), __LINE__);
        }
        $this->BillingZip = $billingZip;
        return $this;
    }
    /**
     * Get BillingCountry value
     * @return string|null
     */
    public function getBillingCountry()
    {
        return $this->BillingCountry;
    }
    /**
     * Set BillingCountry value
     * @param string $billingCountry
     * @return \StructType\PaymentResponse
     */
    public function setBillingCountry($billingCountry = null)
    {
        // validation for constraint: string
        if (!is_null($billingCountry) && !is_string($billingCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCountry)), __LINE__);
        }
        $this->BillingCountry = $billingCountry;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \StructType\PaymentResponse
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\PaymentResponse
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get CreditCardNumberDisplay value
     * @return string|null
     */
    public function getCreditCardNumberDisplay()
    {
        return $this->CreditCardNumberDisplay;
    }
    /**
     * Set CreditCardNumberDisplay value
     * @param string $creditCardNumberDisplay
     * @return \StructType\PaymentResponse
     */
    public function setCreditCardNumberDisplay($creditCardNumberDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardNumberDisplay) && !is_string($creditCardNumberDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditCardNumberDisplay)), __LINE__);
        }
        $this->CreditCardNumberDisplay = $creditCardNumberDisplay;
        return $this;
    }
    /**
     * Get AuthorizationCode value
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return $this->AuthorizationCode;
    }
    /**
     * Set AuthorizationCode value
     * @param string $authorizationCode
     * @return \StructType\PaymentResponse
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorizationCode)), __LINE__);
        }
        $this->AuthorizationCode = $authorizationCode;
        return $this;
    }
    /**
     * Get CreditCardTypeDescription value
     * @return string|null
     */
    public function getCreditCardTypeDescription()
    {
        return $this->CreditCardTypeDescription;
    }
    /**
     * Set CreditCardTypeDescription value
     * @param string $creditCardTypeDescription
     * @return \StructType\PaymentResponse
     */
    public function setCreditCardTypeDescription($creditCardTypeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardTypeDescription) && !is_string($creditCardTypeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditCardTypeDescription)), __LINE__);
        }
        $this->CreditCardTypeDescription = $creditCardTypeDescription;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\PaymentResponse
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\PaymentResponse
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
