<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderResponse StructType
 * @subpackage Structs
 */
class OrderResponse extends AbstractStructBase
{
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderID;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The OrderStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderStatus;
    /**
     * The OrderDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderDate;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WarehouseID;
    /**
     * The ShipMethodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ShipMethodID;
    /**
     * The PriceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PriceType;
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Total;
    /**
     * The SubTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SubTotal;
    /**
     * The TaxTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxTotal;
    /**
     * The ShippingTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ShippingTotal;
    /**
     * The DiscountTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DiscountTotal;
    /**
     * The DiscountPercent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DiscountPercent;
    /**
     * The WeightTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $WeightTotal;
    /**
     * The BusinessVolumeTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BusinessVolumeTotal;
    /**
     * The CommissionableVolumeTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CommissionableVolumeTotal;
    /**
     * The Other1Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Other1Total;
    /**
     * The Other2Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Other2Total;
    /**
     * The Other3Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Other3Total;
    /**
     * The Other4Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Other4Total;
    /**
     * The Other5Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Other5Total;
    /**
     * The Other6Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Other6Total;
    /**
     * The Other7Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Other7Total;
    /**
     * The Other8Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Other8Total;
    /**
     * The Other9Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Other9Total;
    /**
     * The Other10Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Other10Total;
    /**
     * The ShippingTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ShippingTax;
    /**
     * The OrderTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OrderTax;
    /**
     * The FedTaxTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FedTaxTotal;
    /**
     * The StateTaxTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $StateTaxTotal;
    /**
     * The FedShippingTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FedShippingTax;
    /**
     * The StateShippingTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $StateShippingTax;
    /**
     * The CityShippingTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CityShippingTax;
    /**
     * The CityLocalShippingTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CityLocalShippingTax;
    /**
     * The CountyShippingTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CountyShippingTax;
    /**
     * The CountyLocalShippingTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CountyLocalShippingTax;
    /**
     * The ModifiedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ModifiedDate;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderType;
    /**
     * The ShippedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ShippedDate;
    /**
     * The CreatedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreatedDate;
    /**
     * The TaxFedRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxFedRate;
    /**
     * The TaxStateRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxStateRate;
    /**
     * The TaxCityRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxCityRate;
    /**
     * The TaxCityLocalRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxCityLocalRate;
    /**
     * The TaxCountyRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxCountyRate;
    /**
     * The TaxCountyLocalRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxCountyLocalRate;
    /**
     * The TaxManualRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxManualRate;
    /**
     * The TaxIsExempt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TaxIsExempt;
    /**
     * The TaxIsOverRide
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TaxIsOverRide;
    /**
     * The AutoOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AutoOrderID;
    /**
     * The PartyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PartyID;
    /**
     * The IsRMA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRMA;
    /**
     * The BackOrderFromID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BackOrderFromID;
    /**
     * The TransferToID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TransferToID;
    /**
     * The SuppressPackSlipPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SuppressPackSlipPrice;
    /**
     * The ReturnOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ReturnOrderID;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The Company
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Company;
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The Address3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address3;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Zip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The County
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $County;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The TrackingNumber1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber1;
    /**
     * The TrackingNumber2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber2;
    /**
     * The TrackingNumber3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber3;
    /**
     * The TrackingNumber4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber4;
    /**
     * The TrackingNumber5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber5;
    /**
     * The Other11
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other11;
    /**
     * The Other12
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other12;
    /**
     * The Other13
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other13;
    /**
     * The Other14
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other14;
    /**
     * The Other15
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other15;
    /**
     * The Other16
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other16;
    /**
     * The Other17
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other17;
    /**
     * The Other18
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other18;
    /**
     * The Other19
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other19;
    /**
     * The Other20
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other20;
    /**
     * The CreatedBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedBy;
    /**
     * The ModifiedBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModifiedBy;
    /**
     * The TaxCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxCity;
    /**
     * The TaxCounty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxCounty;
    /**
     * The TaxState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxState;
    /**
     * The TaxZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxZip;
    /**
     * The TaxCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxCountry;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOrderDetailResponse
     */
    public $Details;
    /**
     * The Payments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPaymentResponse
     */
    public $Payments;
    /**
     * The ExpectedPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfExpectedPaymentResponse
     */
    public $ExpectedPayments;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustomerResponse
     */
    public $Customer;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MiddleName;
    /**
     * The NameSuffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameSuffix;
    /**
     * The Reference1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference1;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for OrderResponse
     * @uses OrderResponse::setOrderID()
     * @uses OrderResponse::setCustomerID()
     * @uses OrderResponse::setOrderStatus()
     * @uses OrderResponse::setOrderDate()
     * @uses OrderResponse::setWarehouseID()
     * @uses OrderResponse::setShipMethodID()
     * @uses OrderResponse::setPriceType()
     * @uses OrderResponse::setTotal()
     * @uses OrderResponse::setSubTotal()
     * @uses OrderResponse::setTaxTotal()
     * @uses OrderResponse::setShippingTotal()
     * @uses OrderResponse::setDiscountTotal()
     * @uses OrderResponse::setDiscountPercent()
     * @uses OrderResponse::setWeightTotal()
     * @uses OrderResponse::setBusinessVolumeTotal()
     * @uses OrderResponse::setCommissionableVolumeTotal()
     * @uses OrderResponse::setOther1Total()
     * @uses OrderResponse::setOther2Total()
     * @uses OrderResponse::setOther3Total()
     * @uses OrderResponse::setOther4Total()
     * @uses OrderResponse::setOther5Total()
     * @uses OrderResponse::setOther6Total()
     * @uses OrderResponse::setOther7Total()
     * @uses OrderResponse::setOther8Total()
     * @uses OrderResponse::setOther9Total()
     * @uses OrderResponse::setOther10Total()
     * @uses OrderResponse::setShippingTax()
     * @uses OrderResponse::setOrderTax()
     * @uses OrderResponse::setFedTaxTotal()
     * @uses OrderResponse::setStateTaxTotal()
     * @uses OrderResponse::setFedShippingTax()
     * @uses OrderResponse::setStateShippingTax()
     * @uses OrderResponse::setCityShippingTax()
     * @uses OrderResponse::setCityLocalShippingTax()
     * @uses OrderResponse::setCountyShippingTax()
     * @uses OrderResponse::setCountyLocalShippingTax()
     * @uses OrderResponse::setModifiedDate()
     * @uses OrderResponse::setOrderType()
     * @uses OrderResponse::setShippedDate()
     * @uses OrderResponse::setCreatedDate()
     * @uses OrderResponse::setTaxFedRate()
     * @uses OrderResponse::setTaxStateRate()
     * @uses OrderResponse::setTaxCityRate()
     * @uses OrderResponse::setTaxCityLocalRate()
     * @uses OrderResponse::setTaxCountyRate()
     * @uses OrderResponse::setTaxCountyLocalRate()
     * @uses OrderResponse::setTaxManualRate()
     * @uses OrderResponse::setTaxIsExempt()
     * @uses OrderResponse::setTaxIsOverRide()
     * @uses OrderResponse::setAutoOrderID()
     * @uses OrderResponse::setPartyID()
     * @uses OrderResponse::setIsRMA()
     * @uses OrderResponse::setBackOrderFromID()
     * @uses OrderResponse::setTransferToID()
     * @uses OrderResponse::setSuppressPackSlipPrice()
     * @uses OrderResponse::setReturnOrderID()
     * @uses OrderResponse::setCurrencyCode()
     * @uses OrderResponse::setFirstName()
     * @uses OrderResponse::setLastName()
     * @uses OrderResponse::setCompany()
     * @uses OrderResponse::setAddress1()
     * @uses OrderResponse::setAddress2()
     * @uses OrderResponse::setAddress3()
     * @uses OrderResponse::setCity()
     * @uses OrderResponse::setState()
     * @uses OrderResponse::setZip()
     * @uses OrderResponse::setCountry()
     * @uses OrderResponse::setCounty()
     * @uses OrderResponse::setEmail()
     * @uses OrderResponse::setPhone()
     * @uses OrderResponse::setNotes()
     * @uses OrderResponse::setTrackingNumber1()
     * @uses OrderResponse::setTrackingNumber2()
     * @uses OrderResponse::setTrackingNumber3()
     * @uses OrderResponse::setTrackingNumber4()
     * @uses OrderResponse::setTrackingNumber5()
     * @uses OrderResponse::setOther11()
     * @uses OrderResponse::setOther12()
     * @uses OrderResponse::setOther13()
     * @uses OrderResponse::setOther14()
     * @uses OrderResponse::setOther15()
     * @uses OrderResponse::setOther16()
     * @uses OrderResponse::setOther17()
     * @uses OrderResponse::setOther18()
     * @uses OrderResponse::setOther19()
     * @uses OrderResponse::setOther20()
     * @uses OrderResponse::setCreatedBy()
     * @uses OrderResponse::setModifiedBy()
     * @uses OrderResponse::setTaxCity()
     * @uses OrderResponse::setTaxCounty()
     * @uses OrderResponse::setTaxState()
     * @uses OrderResponse::setTaxZip()
     * @uses OrderResponse::setTaxCountry()
     * @uses OrderResponse::setDetails()
     * @uses OrderResponse::setPayments()
     * @uses OrderResponse::setExpectedPayments()
     * @uses OrderResponse::setCustomer()
     * @uses OrderResponse::setMiddleName()
     * @uses OrderResponse::setNameSuffix()
     * @uses OrderResponse::setReference1()
     * @uses OrderResponse::setOrderKey()
     * @uses OrderResponse::setCustomerKey()
     * @param int $orderID
     * @param int $customerID
     * @param string $orderStatus
     * @param string $orderDate
     * @param int $warehouseID
     * @param int $shipMethodID
     * @param int $priceType
     * @param float $total
     * @param float $subTotal
     * @param float $taxTotal
     * @param float $shippingTotal
     * @param float $discountTotal
     * @param float $discountPercent
     * @param float $weightTotal
     * @param float $businessVolumeTotal
     * @param float $commissionableVolumeTotal
     * @param float $other1Total
     * @param float $other2Total
     * @param float $other3Total
     * @param float $other4Total
     * @param float $other5Total
     * @param float $other6Total
     * @param float $other7Total
     * @param float $other8Total
     * @param float $other9Total
     * @param float $other10Total
     * @param float $shippingTax
     * @param float $orderTax
     * @param float $fedTaxTotal
     * @param float $stateTaxTotal
     * @param float $fedShippingTax
     * @param float $stateShippingTax
     * @param float $cityShippingTax
     * @param float $cityLocalShippingTax
     * @param float $countyShippingTax
     * @param float $countyLocalShippingTax
     * @param string $modifiedDate
     * @param string $orderType
     * @param string $shippedDate
     * @param string $createdDate
     * @param float $taxFedRate
     * @param float $taxStateRate
     * @param float $taxCityRate
     * @param float $taxCityLocalRate
     * @param float $taxCountyRate
     * @param float $taxCountyLocalRate
     * @param float $taxManualRate
     * @param bool $taxIsExempt
     * @param bool $taxIsOverRide
     * @param int $autoOrderID
     * @param int $partyID
     * @param bool $isRMA
     * @param int $backOrderFromID
     * @param int $transferToID
     * @param bool $suppressPackSlipPrice
     * @param int $returnOrderID
     * @param string $currencyCode
     * @param string $firstName
     * @param string $lastName
     * @param string $company
     * @param string $address1
     * @param string $address2
     * @param string $address3
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $country
     * @param string $county
     * @param string $email
     * @param string $phone
     * @param string $notes
     * @param string $trackingNumber1
     * @param string $trackingNumber2
     * @param string $trackingNumber3
     * @param string $trackingNumber4
     * @param string $trackingNumber5
     * @param string $other11
     * @param string $other12
     * @param string $other13
     * @param string $other14
     * @param string $other15
     * @param string $other16
     * @param string $other17
     * @param string $other18
     * @param string $other19
     * @param string $other20
     * @param string $createdBy
     * @param string $modifiedBy
     * @param string $taxCity
     * @param string $taxCounty
     * @param string $taxState
     * @param string $taxZip
     * @param string $taxCountry
     * @param \ArrayType\ArrayOfOrderDetailResponse $details
     * @param \ArrayType\ArrayOfPaymentResponse $payments
     * @param \ArrayType\ArrayOfExpectedPaymentResponse $expectedPayments
     * @param \StructType\CustomerResponse $customer
     * @param string $middleName
     * @param string $nameSuffix
     * @param string $reference1
     * @param string $orderKey
     * @param string $customerKey
     */
    public function __construct($orderID = null, $customerID = null, $orderStatus = null, $orderDate = null, $warehouseID = null, $shipMethodID = null, $priceType = null, $total = null, $subTotal = null, $taxTotal = null, $shippingTotal = null, $discountTotal = null, $discountPercent = null, $weightTotal = null, $businessVolumeTotal = null, $commissionableVolumeTotal = null, $other1Total = null, $other2Total = null, $other3Total = null, $other4Total = null, $other5Total = null, $other6Total = null, $other7Total = null, $other8Total = null, $other9Total = null, $other10Total = null, $shippingTax = null, $orderTax = null, $fedTaxTotal = null, $stateTaxTotal = null, $fedShippingTax = null, $stateShippingTax = null, $cityShippingTax = null, $cityLocalShippingTax = null, $countyShippingTax = null, $countyLocalShippingTax = null, $modifiedDate = null, $orderType = null, $shippedDate = null, $createdDate = null, $taxFedRate = null, $taxStateRate = null, $taxCityRate = null, $taxCityLocalRate = null, $taxCountyRate = null, $taxCountyLocalRate = null, $taxManualRate = null, $taxIsExempt = null, $taxIsOverRide = null, $autoOrderID = null, $partyID = null, $isRMA = null, $backOrderFromID = null, $transferToID = null, $suppressPackSlipPrice = null, $returnOrderID = null, $currencyCode = null, $firstName = null, $lastName = null, $company = null, $address1 = null, $address2 = null, $address3 = null, $city = null, $state = null, $zip = null, $country = null, $county = null, $email = null, $phone = null, $notes = null, $trackingNumber1 = null, $trackingNumber2 = null, $trackingNumber3 = null, $trackingNumber4 = null, $trackingNumber5 = null, $other11 = null, $other12 = null, $other13 = null, $other14 = null, $other15 = null, $other16 = null, $other17 = null, $other18 = null, $other19 = null, $other20 = null, $createdBy = null, $modifiedBy = null, $taxCity = null, $taxCounty = null, $taxState = null, $taxZip = null, $taxCountry = null, \ArrayType\ArrayOfOrderDetailResponse $details = null, \ArrayType\ArrayOfPaymentResponse $payments = null, \ArrayType\ArrayOfExpectedPaymentResponse $expectedPayments = null, \StructType\CustomerResponse $customer = null, $middleName = null, $nameSuffix = null, $reference1 = null, $orderKey = null, $customerKey = null)
    {
        $this
            ->setOrderID($orderID)
            ->setCustomerID($customerID)
            ->setOrderStatus($orderStatus)
            ->setOrderDate($orderDate)
            ->setWarehouseID($warehouseID)
            ->setShipMethodID($shipMethodID)
            ->setPriceType($priceType)
            ->setTotal($total)
            ->setSubTotal($subTotal)
            ->setTaxTotal($taxTotal)
            ->setShippingTotal($shippingTotal)
            ->setDiscountTotal($discountTotal)
            ->setDiscountPercent($discountPercent)
            ->setWeightTotal($weightTotal)
            ->setBusinessVolumeTotal($businessVolumeTotal)
            ->setCommissionableVolumeTotal($commissionableVolumeTotal)
            ->setOther1Total($other1Total)
            ->setOther2Total($other2Total)
            ->setOther3Total($other3Total)
            ->setOther4Total($other4Total)
            ->setOther5Total($other5Total)
            ->setOther6Total($other6Total)
            ->setOther7Total($other7Total)
            ->setOther8Total($other8Total)
            ->setOther9Total($other9Total)
            ->setOther10Total($other10Total)
            ->setShippingTax($shippingTax)
            ->setOrderTax($orderTax)
            ->setFedTaxTotal($fedTaxTotal)
            ->setStateTaxTotal($stateTaxTotal)
            ->setFedShippingTax($fedShippingTax)
            ->setStateShippingTax($stateShippingTax)
            ->setCityShippingTax($cityShippingTax)
            ->setCityLocalShippingTax($cityLocalShippingTax)
            ->setCountyShippingTax($countyShippingTax)
            ->setCountyLocalShippingTax($countyLocalShippingTax)
            ->setModifiedDate($modifiedDate)
            ->setOrderType($orderType)
            ->setShippedDate($shippedDate)
            ->setCreatedDate($createdDate)
            ->setTaxFedRate($taxFedRate)
            ->setTaxStateRate($taxStateRate)
            ->setTaxCityRate($taxCityRate)
            ->setTaxCityLocalRate($taxCityLocalRate)
            ->setTaxCountyRate($taxCountyRate)
            ->setTaxCountyLocalRate($taxCountyLocalRate)
            ->setTaxManualRate($taxManualRate)
            ->setTaxIsExempt($taxIsExempt)
            ->setTaxIsOverRide($taxIsOverRide)
            ->setAutoOrderID($autoOrderID)
            ->setPartyID($partyID)
            ->setIsRMA($isRMA)
            ->setBackOrderFromID($backOrderFromID)
            ->setTransferToID($transferToID)
            ->setSuppressPackSlipPrice($suppressPackSlipPrice)
            ->setReturnOrderID($returnOrderID)
            ->setCurrencyCode($currencyCode)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setCompany($company)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip)
            ->setCountry($country)
            ->setCounty($county)
            ->setEmail($email)
            ->setPhone($phone)
            ->setNotes($notes)
            ->setTrackingNumber1($trackingNumber1)
            ->setTrackingNumber2($trackingNumber2)
            ->setTrackingNumber3($trackingNumber3)
            ->setTrackingNumber4($trackingNumber4)
            ->setTrackingNumber5($trackingNumber5)
            ->setOther11($other11)
            ->setOther12($other12)
            ->setOther13($other13)
            ->setOther14($other14)
            ->setOther15($other15)
            ->setOther16($other16)
            ->setOther17($other17)
            ->setOther18($other18)
            ->setOther19($other19)
            ->setOther20($other20)
            ->setCreatedBy($createdBy)
            ->setModifiedBy($modifiedBy)
            ->setTaxCity($taxCity)
            ->setTaxCounty($taxCounty)
            ->setTaxState($taxState)
            ->setTaxZip($taxZip)
            ->setTaxCountry($taxCountry)
            ->setDetails($details)
            ->setPayments($payments)
            ->setExpectedPayments($expectedPayments)
            ->setCustomer($customer)
            ->setMiddleName($middleName)
            ->setNameSuffix($nameSuffix)
            ->setReference1($reference1)
            ->setOrderKey($orderKey)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\OrderResponse
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\OrderResponse
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get OrderStatus value
     * @return string
     */
    public function getOrderStatus()
    {
        return $this->OrderStatus;
    }
    /**
     * Set OrderStatus value
     * @uses \EnumType\OrderStatusType::valueIsValid()
     * @uses \EnumType\OrderStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderStatus
     * @return \StructType\OrderResponse
     */
    public function setOrderStatus($orderStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderStatusType::valueIsValid($orderStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $orderStatus, implode(', ', \EnumType\OrderStatusType::getValidValues())), __LINE__);
        }
        $this->OrderStatus = $orderStatus;
        return $this;
    }
    /**
     * Get OrderDate value
     * @return string
     */
    public function getOrderDate()
    {
        return $this->OrderDate;
    }
    /**
     * Set OrderDate value
     * @param string $orderDate
     * @return \StructType\OrderResponse
     */
    public function setOrderDate($orderDate = null)
    {
        // validation for constraint: string
        if (!is_null($orderDate) && !is_string($orderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderDate)), __LINE__);
        }
        $this->OrderDate = $orderDate;
        return $this;
    }
    /**
     * Get WarehouseID value
     * @return int
     */
    public function getWarehouseID()
    {
        return $this->WarehouseID;
    }
    /**
     * Set WarehouseID value
     * @param int $warehouseID
     * @return \StructType\OrderResponse
     */
    public function setWarehouseID($warehouseID = null)
    {
        // validation for constraint: int
        if (!is_null($warehouseID) && !is_numeric($warehouseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($warehouseID)), __LINE__);
        }
        $this->WarehouseID = $warehouseID;
        return $this;
    }
    /**
     * Get ShipMethodID value
     * @return int
     */
    public function getShipMethodID()
    {
        return $this->ShipMethodID;
    }
    /**
     * Set ShipMethodID value
     * @param int $shipMethodID
     * @return \StructType\OrderResponse
     */
    public function setShipMethodID($shipMethodID = null)
    {
        // validation for constraint: int
        if (!is_null($shipMethodID) && !is_numeric($shipMethodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($shipMethodID)), __LINE__);
        }
        $this->ShipMethodID = $shipMethodID;
        return $this;
    }
    /**
     * Get PriceType value
     * @return int
     */
    public function getPriceType()
    {
        return $this->PriceType;
    }
    /**
     * Set PriceType value
     * @param int $priceType
     * @return \StructType\OrderResponse
     */
    public function setPriceType($priceType = null)
    {
        // validation for constraint: int
        if (!is_null($priceType) && !is_numeric($priceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($priceType)), __LINE__);
        }
        $this->PriceType = $priceType;
        return $this;
    }
    /**
     * Get Total value
     * @return float
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param float $total
     * @return \StructType\OrderResponse
     */
    public function setTotal($total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get SubTotal value
     * @return float
     */
    public function getSubTotal()
    {
        return $this->SubTotal;
    }
    /**
     * Set SubTotal value
     * @param float $subTotal
     * @return \StructType\OrderResponse
     */
    public function setSubTotal($subTotal = null)
    {
        $this->SubTotal = $subTotal;
        return $this;
    }
    /**
     * Get TaxTotal value
     * @return float
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }
    /**
     * Set TaxTotal value
     * @param float $taxTotal
     * @return \StructType\OrderResponse
     */
    public function setTaxTotal($taxTotal = null)
    {
        $this->TaxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get ShippingTotal value
     * @return float
     */
    public function getShippingTotal()
    {
        return $this->ShippingTotal;
    }
    /**
     * Set ShippingTotal value
     * @param float $shippingTotal
     * @return \StructType\OrderResponse
     */
    public function setShippingTotal($shippingTotal = null)
    {
        $this->ShippingTotal = $shippingTotal;
        return $this;
    }
    /**
     * Get DiscountTotal value
     * @return float
     */
    public function getDiscountTotal()
    {
        return $this->DiscountTotal;
    }
    /**
     * Set DiscountTotal value
     * @param float $discountTotal
     * @return \StructType\OrderResponse
     */
    public function setDiscountTotal($discountTotal = null)
    {
        $this->DiscountTotal = $discountTotal;
        return $this;
    }
    /**
     * Get DiscountPercent value
     * @return float
     */
    public function getDiscountPercent()
    {
        return $this->DiscountPercent;
    }
    /**
     * Set DiscountPercent value
     * @param float $discountPercent
     * @return \StructType\OrderResponse
     */
    public function setDiscountPercent($discountPercent = null)
    {
        $this->DiscountPercent = $discountPercent;
        return $this;
    }
    /**
     * Get WeightTotal value
     * @return float
     */
    public function getWeightTotal()
    {
        return $this->WeightTotal;
    }
    /**
     * Set WeightTotal value
     * @param float $weightTotal
     * @return \StructType\OrderResponse
     */
    public function setWeightTotal($weightTotal = null)
    {
        $this->WeightTotal = $weightTotal;
        return $this;
    }
    /**
     * Get BusinessVolumeTotal value
     * @return float
     */
    public function getBusinessVolumeTotal()
    {
        return $this->BusinessVolumeTotal;
    }
    /**
     * Set BusinessVolumeTotal value
     * @param float $businessVolumeTotal
     * @return \StructType\OrderResponse
     */
    public function setBusinessVolumeTotal($businessVolumeTotal = null)
    {
        $this->BusinessVolumeTotal = $businessVolumeTotal;
        return $this;
    }
    /**
     * Get CommissionableVolumeTotal value
     * @return float
     */
    public function getCommissionableVolumeTotal()
    {
        return $this->CommissionableVolumeTotal;
    }
    /**
     * Set CommissionableVolumeTotal value
     * @param float $commissionableVolumeTotal
     * @return \StructType\OrderResponse
     */
    public function setCommissionableVolumeTotal($commissionableVolumeTotal = null)
    {
        $this->CommissionableVolumeTotal = $commissionableVolumeTotal;
        return $this;
    }
    /**
     * Get Other1Total value
     * @return float
     */
    public function getOther1Total()
    {
        return $this->Other1Total;
    }
    /**
     * Set Other1Total value
     * @param float $other1Total
     * @return \StructType\OrderResponse
     */
    public function setOther1Total($other1Total = null)
    {
        $this->Other1Total = $other1Total;
        return $this;
    }
    /**
     * Get Other2Total value
     * @return float
     */
    public function getOther2Total()
    {
        return $this->Other2Total;
    }
    /**
     * Set Other2Total value
     * @param float $other2Total
     * @return \StructType\OrderResponse
     */
    public function setOther2Total($other2Total = null)
    {
        $this->Other2Total = $other2Total;
        return $this;
    }
    /**
     * Get Other3Total value
     * @return float
     */
    public function getOther3Total()
    {
        return $this->Other3Total;
    }
    /**
     * Set Other3Total value
     * @param float $other3Total
     * @return \StructType\OrderResponse
     */
    public function setOther3Total($other3Total = null)
    {
        $this->Other3Total = $other3Total;
        return $this;
    }
    /**
     * Get Other4Total value
     * @return float
     */
    public function getOther4Total()
    {
        return $this->Other4Total;
    }
    /**
     * Set Other4Total value
     * @param float $other4Total
     * @return \StructType\OrderResponse
     */
    public function setOther4Total($other4Total = null)
    {
        $this->Other4Total = $other4Total;
        return $this;
    }
    /**
     * Get Other5Total value
     * @return float
     */
    public function getOther5Total()
    {
        return $this->Other5Total;
    }
    /**
     * Set Other5Total value
     * @param float $other5Total
     * @return \StructType\OrderResponse
     */
    public function setOther5Total($other5Total = null)
    {
        $this->Other5Total = $other5Total;
        return $this;
    }
    /**
     * Get Other6Total value
     * @return float
     */
    public function getOther6Total()
    {
        return $this->Other6Total;
    }
    /**
     * Set Other6Total value
     * @param float $other6Total
     * @return \StructType\OrderResponse
     */
    public function setOther6Total($other6Total = null)
    {
        $this->Other6Total = $other6Total;
        return $this;
    }
    /**
     * Get Other7Total value
     * @return float
     */
    public function getOther7Total()
    {
        return $this->Other7Total;
    }
    /**
     * Set Other7Total value
     * @param float $other7Total
     * @return \StructType\OrderResponse
     */
    public function setOther7Total($other7Total = null)
    {
        $this->Other7Total = $other7Total;
        return $this;
    }
    /**
     * Get Other8Total value
     * @return float
     */
    public function getOther8Total()
    {
        return $this->Other8Total;
    }
    /**
     * Set Other8Total value
     * @param float $other8Total
     * @return \StructType\OrderResponse
     */
    public function setOther8Total($other8Total = null)
    {
        $this->Other8Total = $other8Total;
        return $this;
    }
    /**
     * Get Other9Total value
     * @return float
     */
    public function getOther9Total()
    {
        return $this->Other9Total;
    }
    /**
     * Set Other9Total value
     * @param float $other9Total
     * @return \StructType\OrderResponse
     */
    public function setOther9Total($other9Total = null)
    {
        $this->Other9Total = $other9Total;
        return $this;
    }
    /**
     * Get Other10Total value
     * @return float
     */
    public function getOther10Total()
    {
        return $this->Other10Total;
    }
    /**
     * Set Other10Total value
     * @param float $other10Total
     * @return \StructType\OrderResponse
     */
    public function setOther10Total($other10Total = null)
    {
        $this->Other10Total = $other10Total;
        return $this;
    }
    /**
     * Get ShippingTax value
     * @return float
     */
    public function getShippingTax()
    {
        return $this->ShippingTax;
    }
    /**
     * Set ShippingTax value
     * @param float $shippingTax
     * @return \StructType\OrderResponse
     */
    public function setShippingTax($shippingTax = null)
    {
        $this->ShippingTax = $shippingTax;
        return $this;
    }
    /**
     * Get OrderTax value
     * @return float
     */
    public function getOrderTax()
    {
        return $this->OrderTax;
    }
    /**
     * Set OrderTax value
     * @param float $orderTax
     * @return \StructType\OrderResponse
     */
    public function setOrderTax($orderTax = null)
    {
        $this->OrderTax = $orderTax;
        return $this;
    }
    /**
     * Get FedTaxTotal value
     * @return float
     */
    public function getFedTaxTotal()
    {
        return $this->FedTaxTotal;
    }
    /**
     * Set FedTaxTotal value
     * @param float $fedTaxTotal
     * @return \StructType\OrderResponse
     */
    public function setFedTaxTotal($fedTaxTotal = null)
    {
        $this->FedTaxTotal = $fedTaxTotal;
        return $this;
    }
    /**
     * Get StateTaxTotal value
     * @return float
     */
    public function getStateTaxTotal()
    {
        return $this->StateTaxTotal;
    }
    /**
     * Set StateTaxTotal value
     * @param float $stateTaxTotal
     * @return \StructType\OrderResponse
     */
    public function setStateTaxTotal($stateTaxTotal = null)
    {
        $this->StateTaxTotal = $stateTaxTotal;
        return $this;
    }
    /**
     * Get FedShippingTax value
     * @return float
     */
    public function getFedShippingTax()
    {
        return $this->FedShippingTax;
    }
    /**
     * Set FedShippingTax value
     * @param float $fedShippingTax
     * @return \StructType\OrderResponse
     */
    public function setFedShippingTax($fedShippingTax = null)
    {
        $this->FedShippingTax = $fedShippingTax;
        return $this;
    }
    /**
     * Get StateShippingTax value
     * @return float
     */
    public function getStateShippingTax()
    {
        return $this->StateShippingTax;
    }
    /**
     * Set StateShippingTax value
     * @param float $stateShippingTax
     * @return \StructType\OrderResponse
     */
    public function setStateShippingTax($stateShippingTax = null)
    {
        $this->StateShippingTax = $stateShippingTax;
        return $this;
    }
    /**
     * Get CityShippingTax value
     * @return float
     */
    public function getCityShippingTax()
    {
        return $this->CityShippingTax;
    }
    /**
     * Set CityShippingTax value
     * @param float $cityShippingTax
     * @return \StructType\OrderResponse
     */
    public function setCityShippingTax($cityShippingTax = null)
    {
        $this->CityShippingTax = $cityShippingTax;
        return $this;
    }
    /**
     * Get CityLocalShippingTax value
     * @return float
     */
    public function getCityLocalShippingTax()
    {
        return $this->CityLocalShippingTax;
    }
    /**
     * Set CityLocalShippingTax value
     * @param float $cityLocalShippingTax
     * @return \StructType\OrderResponse
     */
    public function setCityLocalShippingTax($cityLocalShippingTax = null)
    {
        $this->CityLocalShippingTax = $cityLocalShippingTax;
        return $this;
    }
    /**
     * Get CountyShippingTax value
     * @return float
     */
    public function getCountyShippingTax()
    {
        return $this->CountyShippingTax;
    }
    /**
     * Set CountyShippingTax value
     * @param float $countyShippingTax
     * @return \StructType\OrderResponse
     */
    public function setCountyShippingTax($countyShippingTax = null)
    {
        $this->CountyShippingTax = $countyShippingTax;
        return $this;
    }
    /**
     * Get CountyLocalShippingTax value
     * @return float
     */
    public function getCountyLocalShippingTax()
    {
        return $this->CountyLocalShippingTax;
    }
    /**
     * Set CountyLocalShippingTax value
     * @param float $countyLocalShippingTax
     * @return \StructType\OrderResponse
     */
    public function setCountyLocalShippingTax($countyLocalShippingTax = null)
    {
        $this->CountyLocalShippingTax = $countyLocalShippingTax;
        return $this;
    }
    /**
     * Get ModifiedDate value
     * @return string
     */
    public function getModifiedDate()
    {
        return $this->ModifiedDate;
    }
    /**
     * Set ModifiedDate value
     * @param string $modifiedDate
     * @return \StructType\OrderResponse
     */
    public function setModifiedDate($modifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDate) && !is_string($modifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifiedDate)), __LINE__);
        }
        $this->ModifiedDate = $modifiedDate;
        return $this;
    }
    /**
     * Get OrderType value
     * @return string
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @uses \EnumType\OrderType::valueIsValid()
     * @uses \EnumType\OrderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderType
     * @return \StructType\OrderResponse
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderType::valueIsValid($orderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $orderType, implode(', ', \EnumType\OrderType::getValidValues())), __LINE__);
        }
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get ShippedDate value
     * @return string
     */
    public function getShippedDate()
    {
        return $this->ShippedDate;
    }
    /**
     * Set ShippedDate value
     * @param string $shippedDate
     * @return \StructType\OrderResponse
     */
    public function setShippedDate($shippedDate = null)
    {
        // validation for constraint: string
        if (!is_null($shippedDate) && !is_string($shippedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippedDate)), __LINE__);
        }
        $this->ShippedDate = $shippedDate;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\OrderResponse
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get TaxFedRate value
     * @return float
     */
    public function getTaxFedRate()
    {
        return $this->TaxFedRate;
    }
    /**
     * Set TaxFedRate value
     * @param float $taxFedRate
     * @return \StructType\OrderResponse
     */
    public function setTaxFedRate($taxFedRate = null)
    {
        $this->TaxFedRate = $taxFedRate;
        return $this;
    }
    /**
     * Get TaxStateRate value
     * @return float
     */
    public function getTaxStateRate()
    {
        return $this->TaxStateRate;
    }
    /**
     * Set TaxStateRate value
     * @param float $taxStateRate
     * @return \StructType\OrderResponse
     */
    public function setTaxStateRate($taxStateRate = null)
    {
        $this->TaxStateRate = $taxStateRate;
        return $this;
    }
    /**
     * Get TaxCityRate value
     * @return float
     */
    public function getTaxCityRate()
    {
        return $this->TaxCityRate;
    }
    /**
     * Set TaxCityRate value
     * @param float $taxCityRate
     * @return \StructType\OrderResponse
     */
    public function setTaxCityRate($taxCityRate = null)
    {
        $this->TaxCityRate = $taxCityRate;
        return $this;
    }
    /**
     * Get TaxCityLocalRate value
     * @return float
     */
    public function getTaxCityLocalRate()
    {
        return $this->TaxCityLocalRate;
    }
    /**
     * Set TaxCityLocalRate value
     * @param float $taxCityLocalRate
     * @return \StructType\OrderResponse
     */
    public function setTaxCityLocalRate($taxCityLocalRate = null)
    {
        $this->TaxCityLocalRate = $taxCityLocalRate;
        return $this;
    }
    /**
     * Get TaxCountyRate value
     * @return float
     */
    public function getTaxCountyRate()
    {
        return $this->TaxCountyRate;
    }
    /**
     * Set TaxCountyRate value
     * @param float $taxCountyRate
     * @return \StructType\OrderResponse
     */
    public function setTaxCountyRate($taxCountyRate = null)
    {
        $this->TaxCountyRate = $taxCountyRate;
        return $this;
    }
    /**
     * Get TaxCountyLocalRate value
     * @return float
     */
    public function getTaxCountyLocalRate()
    {
        return $this->TaxCountyLocalRate;
    }
    /**
     * Set TaxCountyLocalRate value
     * @param float $taxCountyLocalRate
     * @return \StructType\OrderResponse
     */
    public function setTaxCountyLocalRate($taxCountyLocalRate = null)
    {
        $this->TaxCountyLocalRate = $taxCountyLocalRate;
        return $this;
    }
    /**
     * Get TaxManualRate value
     * @return float
     */
    public function getTaxManualRate()
    {
        return $this->TaxManualRate;
    }
    /**
     * Set TaxManualRate value
     * @param float $taxManualRate
     * @return \StructType\OrderResponse
     */
    public function setTaxManualRate($taxManualRate = null)
    {
        $this->TaxManualRate = $taxManualRate;
        return $this;
    }
    /**
     * Get TaxIsExempt value
     * @return bool
     */
    public function getTaxIsExempt()
    {
        return $this->TaxIsExempt;
    }
    /**
     * Set TaxIsExempt value
     * @param bool $taxIsExempt
     * @return \StructType\OrderResponse
     */
    public function setTaxIsExempt($taxIsExempt = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxIsExempt) && !is_bool($taxIsExempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($taxIsExempt)), __LINE__);
        }
        $this->TaxIsExempt = $taxIsExempt;
        return $this;
    }
    /**
     * Get TaxIsOverRide value
     * @return bool
     */
    public function getTaxIsOverRide()
    {
        return $this->TaxIsOverRide;
    }
    /**
     * Set TaxIsOverRide value
     * @param bool $taxIsOverRide
     * @return \StructType\OrderResponse
     */
    public function setTaxIsOverRide($taxIsOverRide = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxIsOverRide) && !is_bool($taxIsOverRide)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($taxIsOverRide)), __LINE__);
        }
        $this->TaxIsOverRide = $taxIsOverRide;
        return $this;
    }
    /**
     * Get AutoOrderID value
     * @return int
     */
    public function getAutoOrderID()
    {
        return $this->AutoOrderID;
    }
    /**
     * Set AutoOrderID value
     * @param int $autoOrderID
     * @return \StructType\OrderResponse
     */
    public function setAutoOrderID($autoOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($autoOrderID) && !is_numeric($autoOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($autoOrderID)), __LINE__);
        }
        $this->AutoOrderID = $autoOrderID;
        return $this;
    }
    /**
     * Get PartyID value
     * @return int
     */
    public function getPartyID()
    {
        return $this->PartyID;
    }
    /**
     * Set PartyID value
     * @param int $partyID
     * @return \StructType\OrderResponse
     */
    public function setPartyID($partyID = null)
    {
        // validation for constraint: int
        if (!is_null($partyID) && !is_numeric($partyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($partyID)), __LINE__);
        }
        $this->PartyID = $partyID;
        return $this;
    }
    /**
     * Get IsRMA value
     * @return bool
     */
    public function getIsRMA()
    {
        return $this->IsRMA;
    }
    /**
     * Set IsRMA value
     * @param bool $isRMA
     * @return \StructType\OrderResponse
     */
    public function setIsRMA($isRMA = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRMA) && !is_bool($isRMA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRMA)), __LINE__);
        }
        $this->IsRMA = $isRMA;
        return $this;
    }
    /**
     * Get BackOrderFromID value
     * @return int
     */
    public function getBackOrderFromID()
    {
        return $this->BackOrderFromID;
    }
    /**
     * Set BackOrderFromID value
     * @param int $backOrderFromID
     * @return \StructType\OrderResponse
     */
    public function setBackOrderFromID($backOrderFromID = null)
    {
        // validation for constraint: int
        if (!is_null($backOrderFromID) && !is_numeric($backOrderFromID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($backOrderFromID)), __LINE__);
        }
        $this->BackOrderFromID = $backOrderFromID;
        return $this;
    }
    /**
     * Get TransferToID value
     * @return int
     */
    public function getTransferToID()
    {
        return $this->TransferToID;
    }
    /**
     * Set TransferToID value
     * @param int $transferToID
     * @return \StructType\OrderResponse
     */
    public function setTransferToID($transferToID = null)
    {
        // validation for constraint: int
        if (!is_null($transferToID) && !is_numeric($transferToID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transferToID)), __LINE__);
        }
        $this->TransferToID = $transferToID;
        return $this;
    }
    /**
     * Get SuppressPackSlipPrice value
     * @return bool
     */
    public function getSuppressPackSlipPrice()
    {
        return $this->SuppressPackSlipPrice;
    }
    /**
     * Set SuppressPackSlipPrice value
     * @param bool $suppressPackSlipPrice
     * @return \StructType\OrderResponse
     */
    public function setSuppressPackSlipPrice($suppressPackSlipPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($suppressPackSlipPrice) && !is_bool($suppressPackSlipPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($suppressPackSlipPrice)), __LINE__);
        }
        $this->SuppressPackSlipPrice = $suppressPackSlipPrice;
        return $this;
    }
    /**
     * Get ReturnOrderID value
     * @return int
     */
    public function getReturnOrderID()
    {
        return $this->ReturnOrderID;
    }
    /**
     * Set ReturnOrderID value
     * @param int $returnOrderID
     * @return \StructType\OrderResponse
     */
    public function setReturnOrderID($returnOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($returnOrderID) && !is_numeric($returnOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($returnOrderID)), __LINE__);
        }
        $this->ReturnOrderID = $returnOrderID;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\OrderResponse
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\OrderResponse
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\OrderResponse
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\OrderResponse
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\OrderResponse
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\OrderResponse
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get Address3 value
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->Address3;
    }
    /**
     * Set Address3 value
     * @param string $address3
     * @return \StructType\OrderResponse
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address3)), __LINE__);
        }
        $this->Address3 = $address3;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\OrderResponse
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\OrderResponse
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \StructType\OrderResponse
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\OrderResponse
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get County value
     * @return string|null
     */
    public function getCounty()
    {
        return $this->County;
    }
    /**
     * Set County value
     * @param string $county
     * @return \StructType\OrderResponse
     */
    public function setCounty($county = null)
    {
        // validation for constraint: string
        if (!is_null($county) && !is_string($county)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($county)), __LINE__);
        }
        $this->County = $county;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\OrderResponse
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\OrderResponse
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\OrderResponse
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get TrackingNumber1 value
     * @return string|null
     */
    public function getTrackingNumber1()
    {
        return $this->TrackingNumber1;
    }
    /**
     * Set TrackingNumber1 value
     * @param string $trackingNumber1
     * @return \StructType\OrderResponse
     */
    public function setTrackingNumber1($trackingNumber1 = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber1) && !is_string($trackingNumber1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingNumber1)), __LINE__);
        }
        $this->TrackingNumber1 = $trackingNumber1;
        return $this;
    }
    /**
     * Get TrackingNumber2 value
     * @return string|null
     */
    public function getTrackingNumber2()
    {
        return $this->TrackingNumber2;
    }
    /**
     * Set TrackingNumber2 value
     * @param string $trackingNumber2
     * @return \StructType\OrderResponse
     */
    public function setTrackingNumber2($trackingNumber2 = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber2) && !is_string($trackingNumber2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingNumber2)), __LINE__);
        }
        $this->TrackingNumber2 = $trackingNumber2;
        return $this;
    }
    /**
     * Get TrackingNumber3 value
     * @return string|null
     */
    public function getTrackingNumber3()
    {
        return $this->TrackingNumber3;
    }
    /**
     * Set TrackingNumber3 value
     * @param string $trackingNumber3
     * @return \StructType\OrderResponse
     */
    public function setTrackingNumber3($trackingNumber3 = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber3) && !is_string($trackingNumber3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingNumber3)), __LINE__);
        }
        $this->TrackingNumber3 = $trackingNumber3;
        return $this;
    }
    /**
     * Get TrackingNumber4 value
     * @return string|null
     */
    public function getTrackingNumber4()
    {
        return $this->TrackingNumber4;
    }
    /**
     * Set TrackingNumber4 value
     * @param string $trackingNumber4
     * @return \StructType\OrderResponse
     */
    public function setTrackingNumber4($trackingNumber4 = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber4) && !is_string($trackingNumber4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingNumber4)), __LINE__);
        }
        $this->TrackingNumber4 = $trackingNumber4;
        return $this;
    }
    /**
     * Get TrackingNumber5 value
     * @return string|null
     */
    public function getTrackingNumber5()
    {
        return $this->TrackingNumber5;
    }
    /**
     * Set TrackingNumber5 value
     * @param string $trackingNumber5
     * @return \StructType\OrderResponse
     */
    public function setTrackingNumber5($trackingNumber5 = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber5) && !is_string($trackingNumber5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingNumber5)), __LINE__);
        }
        $this->TrackingNumber5 = $trackingNumber5;
        return $this;
    }
    /**
     * Get Other11 value
     * @return string|null
     */
    public function getOther11()
    {
        return $this->Other11;
    }
    /**
     * Set Other11 value
     * @param string $other11
     * @return \StructType\OrderResponse
     */
    public function setOther11($other11 = null)
    {
        // validation for constraint: string
        if (!is_null($other11) && !is_string($other11)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other11)), __LINE__);
        }
        $this->Other11 = $other11;
        return $this;
    }
    /**
     * Get Other12 value
     * @return string|null
     */
    public function getOther12()
    {
        return $this->Other12;
    }
    /**
     * Set Other12 value
     * @param string $other12
     * @return \StructType\OrderResponse
     */
    public function setOther12($other12 = null)
    {
        // validation for constraint: string
        if (!is_null($other12) && !is_string($other12)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other12)), __LINE__);
        }
        $this->Other12 = $other12;
        return $this;
    }
    /**
     * Get Other13 value
     * @return string|null
     */
    public function getOther13()
    {
        return $this->Other13;
    }
    /**
     * Set Other13 value
     * @param string $other13
     * @return \StructType\OrderResponse
     */
    public function setOther13($other13 = null)
    {
        // validation for constraint: string
        if (!is_null($other13) && !is_string($other13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other13)), __LINE__);
        }
        $this->Other13 = $other13;
        return $this;
    }
    /**
     * Get Other14 value
     * @return string|null
     */
    public function getOther14()
    {
        return $this->Other14;
    }
    /**
     * Set Other14 value
     * @param string $other14
     * @return \StructType\OrderResponse
     */
    public function setOther14($other14 = null)
    {
        // validation for constraint: string
        if (!is_null($other14) && !is_string($other14)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other14)), __LINE__);
        }
        $this->Other14 = $other14;
        return $this;
    }
    /**
     * Get Other15 value
     * @return string|null
     */
    public function getOther15()
    {
        return $this->Other15;
    }
    /**
     * Set Other15 value
     * @param string $other15
     * @return \StructType\OrderResponse
     */
    public function setOther15($other15 = null)
    {
        // validation for constraint: string
        if (!is_null($other15) && !is_string($other15)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other15)), __LINE__);
        }
        $this->Other15 = $other15;
        return $this;
    }
    /**
     * Get Other16 value
     * @return string|null
     */
    public function getOther16()
    {
        return $this->Other16;
    }
    /**
     * Set Other16 value
     * @param string $other16
     * @return \StructType\OrderResponse
     */
    public function setOther16($other16 = null)
    {
        // validation for constraint: string
        if (!is_null($other16) && !is_string($other16)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other16)), __LINE__);
        }
        $this->Other16 = $other16;
        return $this;
    }
    /**
     * Get Other17 value
     * @return string|null
     */
    public function getOther17()
    {
        return $this->Other17;
    }
    /**
     * Set Other17 value
     * @param string $other17
     * @return \StructType\OrderResponse
     */
    public function setOther17($other17 = null)
    {
        // validation for constraint: string
        if (!is_null($other17) && !is_string($other17)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other17)), __LINE__);
        }
        $this->Other17 = $other17;
        return $this;
    }
    /**
     * Get Other18 value
     * @return string|null
     */
    public function getOther18()
    {
        return $this->Other18;
    }
    /**
     * Set Other18 value
     * @param string $other18
     * @return \StructType\OrderResponse
     */
    public function setOther18($other18 = null)
    {
        // validation for constraint: string
        if (!is_null($other18) && !is_string($other18)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other18)), __LINE__);
        }
        $this->Other18 = $other18;
        return $this;
    }
    /**
     * Get Other19 value
     * @return string|null
     */
    public function getOther19()
    {
        return $this->Other19;
    }
    /**
     * Set Other19 value
     * @param string $other19
     * @return \StructType\OrderResponse
     */
    public function setOther19($other19 = null)
    {
        // validation for constraint: string
        if (!is_null($other19) && !is_string($other19)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other19)), __LINE__);
        }
        $this->Other19 = $other19;
        return $this;
    }
    /**
     * Get Other20 value
     * @return string|null
     */
    public function getOther20()
    {
        return $this->Other20;
    }
    /**
     * Set Other20 value
     * @param string $other20
     * @return \StructType\OrderResponse
     */
    public function setOther20($other20 = null)
    {
        // validation for constraint: string
        if (!is_null($other20) && !is_string($other20)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other20)), __LINE__);
        }
        $this->Other20 = $other20;
        return $this;
    }
    /**
     * Get CreatedBy value
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->CreatedBy;
    }
    /**
     * Set CreatedBy value
     * @param string $createdBy
     * @return \StructType\OrderResponse
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdBy)), __LINE__);
        }
        $this->CreatedBy = $createdBy;
        return $this;
    }
    /**
     * Get ModifiedBy value
     * @return string|null
     */
    public function getModifiedBy()
    {
        return $this->ModifiedBy;
    }
    /**
     * Set ModifiedBy value
     * @param string $modifiedBy
     * @return \StructType\OrderResponse
     */
    public function setModifiedBy($modifiedBy = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedBy) && !is_string($modifiedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifiedBy)), __LINE__);
        }
        $this->ModifiedBy = $modifiedBy;
        return $this;
    }
    /**
     * Get TaxCity value
     * @return string|null
     */
    public function getTaxCity()
    {
        return $this->TaxCity;
    }
    /**
     * Set TaxCity value
     * @param string $taxCity
     * @return \StructType\OrderResponse
     */
    public function setTaxCity($taxCity = null)
    {
        // validation for constraint: string
        if (!is_null($taxCity) && !is_string($taxCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxCity)), __LINE__);
        }
        $this->TaxCity = $taxCity;
        return $this;
    }
    /**
     * Get TaxCounty value
     * @return string|null
     */
    public function getTaxCounty()
    {
        return $this->TaxCounty;
    }
    /**
     * Set TaxCounty value
     * @param string $taxCounty
     * @return \StructType\OrderResponse
     */
    public function setTaxCounty($taxCounty = null)
    {
        // validation for constraint: string
        if (!is_null($taxCounty) && !is_string($taxCounty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxCounty)), __LINE__);
        }
        $this->TaxCounty = $taxCounty;
        return $this;
    }
    /**
     * Get TaxState value
     * @return string|null
     */
    public function getTaxState()
    {
        return $this->TaxState;
    }
    /**
     * Set TaxState value
     * @param string $taxState
     * @return \StructType\OrderResponse
     */
    public function setTaxState($taxState = null)
    {
        // validation for constraint: string
        if (!is_null($taxState) && !is_string($taxState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxState)), __LINE__);
        }
        $this->TaxState = $taxState;
        return $this;
    }
    /**
     * Get TaxZip value
     * @return string|null
     */
    public function getTaxZip()
    {
        return $this->TaxZip;
    }
    /**
     * Set TaxZip value
     * @param string $taxZip
     * @return \StructType\OrderResponse
     */
    public function setTaxZip($taxZip = null)
    {
        // validation for constraint: string
        if (!is_null($taxZip) && !is_string($taxZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxZip)), __LINE__);
        }
        $this->TaxZip = $taxZip;
        return $this;
    }
    /**
     * Get TaxCountry value
     * @return string|null
     */
    public function getTaxCountry()
    {
        return $this->TaxCountry;
    }
    /**
     * Set TaxCountry value
     * @param string $taxCountry
     * @return \StructType\OrderResponse
     */
    public function setTaxCountry($taxCountry = null)
    {
        // validation for constraint: string
        if (!is_null($taxCountry) && !is_string($taxCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxCountry)), __LINE__);
        }
        $this->TaxCountry = $taxCountry;
        return $this;
    }
    /**
     * Get Details value
     * @return \ArrayType\ArrayOfOrderDetailResponse|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \ArrayType\ArrayOfOrderDetailResponse $details
     * @return \StructType\OrderResponse
     */
    public function setDetails(\ArrayType\ArrayOfOrderDetailResponse $details = null)
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Get Payments value
     * @return \ArrayType\ArrayOfPaymentResponse|null
     */
    public function getPayments()
    {
        return $this->Payments;
    }
    /**
     * Set Payments value
     * @param \ArrayType\ArrayOfPaymentResponse $payments
     * @return \StructType\OrderResponse
     */
    public function setPayments(\ArrayType\ArrayOfPaymentResponse $payments = null)
    {
        $this->Payments = $payments;
        return $this;
    }
    /**
     * Get ExpectedPayments value
     * @return \ArrayType\ArrayOfExpectedPaymentResponse|null
     */
    public function getExpectedPayments()
    {
        return $this->ExpectedPayments;
    }
    /**
     * Set ExpectedPayments value
     * @param \ArrayType\ArrayOfExpectedPaymentResponse $expectedPayments
     * @return \StructType\OrderResponse
     */
    public function setExpectedPayments(\ArrayType\ArrayOfExpectedPaymentResponse $expectedPayments = null)
    {
        $this->ExpectedPayments = $expectedPayments;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\CustomerResponse|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\CustomerResponse $customer
     * @return \StructType\OrderResponse
     */
    public function setCustomer(\StructType\CustomerResponse $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\OrderResponse
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get NameSuffix value
     * @return string|null
     */
    public function getNameSuffix()
    {
        return $this->NameSuffix;
    }
    /**
     * Set NameSuffix value
     * @param string $nameSuffix
     * @return \StructType\OrderResponse
     */
    public function setNameSuffix($nameSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($nameSuffix) && !is_string($nameSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameSuffix)), __LINE__);
        }
        $this->NameSuffix = $nameSuffix;
        return $this;
    }
    /**
     * Get Reference1 value
     * @return string|null
     */
    public function getReference1()
    {
        return $this->Reference1;
    }
    /**
     * Set Reference1 value
     * @param string $reference1
     * @return \StructType\OrderResponse
     */
    public function setReference1($reference1 = null)
    {
        // validation for constraint: string
        if (!is_null($reference1) && !is_string($reference1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference1)), __LINE__);
        }
        $this->Reference1 = $reference1;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\OrderResponse
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\OrderResponse
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
