<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderBatchDetailRequest StructType
 * @subpackage Structs
 */
class OrderBatchDetailRequest extends AbstractStructBase
{
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderID;
    /**
     * The TrackingNumber1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TrackingNumber1;
    /**
     * The TrackingNumber2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TrackingNumber2;
    /**
     * The TrackingNumber3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TrackingNumber3;
    /**
     * The TrackingNumber4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TrackingNumber4;
    /**
     * The TrackingNumber5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TrackingNumber5;
    /**
     * The ShippedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ShippedDate;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * Constructor method for OrderBatchDetailRequest
     * @uses OrderBatchDetailRequest::setOrderID()
     * @uses OrderBatchDetailRequest::setTrackingNumber1()
     * @uses OrderBatchDetailRequest::setTrackingNumber2()
     * @uses OrderBatchDetailRequest::setTrackingNumber3()
     * @uses OrderBatchDetailRequest::setTrackingNumber4()
     * @uses OrderBatchDetailRequest::setTrackingNumber5()
     * @uses OrderBatchDetailRequest::setShippedDate()
     * @uses OrderBatchDetailRequest::setOrderKey()
     * @param int $orderID
     * @param string $trackingNumber1
     * @param string $trackingNumber2
     * @param string $trackingNumber3
     * @param string $trackingNumber4
     * @param string $trackingNumber5
     * @param string $shippedDate
     * @param string $orderKey
     */
    public function __construct($orderID = null, $trackingNumber1 = null, $trackingNumber2 = null, $trackingNumber3 = null, $trackingNumber4 = null, $trackingNumber5 = null, $shippedDate = null, $orderKey = null)
    {
        $this
            ->setOrderID($orderID)
            ->setTrackingNumber1($trackingNumber1)
            ->setTrackingNumber2($trackingNumber2)
            ->setTrackingNumber3($trackingNumber3)
            ->setTrackingNumber4($trackingNumber4)
            ->setTrackingNumber5($trackingNumber5)
            ->setShippedDate($shippedDate)
            ->setOrderKey($orderKey);
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\OrderBatchDetailRequest
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get TrackingNumber1 value
     * @return string
     */
    public function getTrackingNumber1()
    {
        return $this->TrackingNumber1;
    }
    /**
     * Set TrackingNumber1 value
     * @param string $trackingNumber1
     * @return \StructType\OrderBatchDetailRequest
     */
    public function setTrackingNumber1($trackingNumber1 = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber1) && !is_string($trackingNumber1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingNumber1)), __LINE__);
        }
        $this->TrackingNumber1 = $trackingNumber1;
        return $this;
    }
    /**
     * Get TrackingNumber2 value
     * @return string
     */
    public function getTrackingNumber2()
    {
        return $this->TrackingNumber2;
    }
    /**
     * Set TrackingNumber2 value
     * @param string $trackingNumber2
     * @return \StructType\OrderBatchDetailRequest
     */
    public function setTrackingNumber2($trackingNumber2 = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber2) && !is_string($trackingNumber2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingNumber2)), __LINE__);
        }
        $this->TrackingNumber2 = $trackingNumber2;
        return $this;
    }
    /**
     * Get TrackingNumber3 value
     * @return string
     */
    public function getTrackingNumber3()
    {
        return $this->TrackingNumber3;
    }
    /**
     * Set TrackingNumber3 value
     * @param string $trackingNumber3
     * @return \StructType\OrderBatchDetailRequest
     */
    public function setTrackingNumber3($trackingNumber3 = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber3) && !is_string($trackingNumber3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingNumber3)), __LINE__);
        }
        $this->TrackingNumber3 = $trackingNumber3;
        return $this;
    }
    /**
     * Get TrackingNumber4 value
     * @return string
     */
    public function getTrackingNumber4()
    {
        return $this->TrackingNumber4;
    }
    /**
     * Set TrackingNumber4 value
     * @param string $trackingNumber4
     * @return \StructType\OrderBatchDetailRequest
     */
    public function setTrackingNumber4($trackingNumber4 = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber4) && !is_string($trackingNumber4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingNumber4)), __LINE__);
        }
        $this->TrackingNumber4 = $trackingNumber4;
        return $this;
    }
    /**
     * Get TrackingNumber5 value
     * @return string
     */
    public function getTrackingNumber5()
    {
        return $this->TrackingNumber5;
    }
    /**
     * Set TrackingNumber5 value
     * @param string $trackingNumber5
     * @return \StructType\OrderBatchDetailRequest
     */
    public function setTrackingNumber5($trackingNumber5 = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber5) && !is_string($trackingNumber5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingNumber5)), __LINE__);
        }
        $this->TrackingNumber5 = $trackingNumber5;
        return $this;
    }
    /**
     * Get ShippedDate value
     * @return string
     */
    public function getShippedDate()
    {
        return $this->ShippedDate;
    }
    /**
     * Set ShippedDate value
     * @param string $shippedDate
     * @return \StructType\OrderBatchDetailRequest
     */
    public function setShippedDate($shippedDate = null)
    {
        // validation for constraint: string
        if (!is_null($shippedDate) && !is_string($shippedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shippedDate)), __LINE__);
        }
        $this->ShippedDate = $shippedDate;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\OrderBatchDetailRequest
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderBatchDetailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
