<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MergeCustomerRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:MergeCustomerRequest
 * @subpackage Structs
 */
class MergeCustomerRequest extends ApiRequest
{
    /**
     * The ToCustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ToCustomerID;
    /**
     * The FromCustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FromCustomerID;
    /**
     * The ToCustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToCustomerKey;
    /**
     * The FromCustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromCustomerKey;
    /**
     * Constructor method for MergeCustomerRequest
     * @uses MergeCustomerRequest::setToCustomerID()
     * @uses MergeCustomerRequest::setFromCustomerID()
     * @uses MergeCustomerRequest::setToCustomerKey()
     * @uses MergeCustomerRequest::setFromCustomerKey()
     * @param int $toCustomerID
     * @param int $fromCustomerID
     * @param string $toCustomerKey
     * @param string $fromCustomerKey
     */
    public function __construct($toCustomerID = null, $fromCustomerID = null, $toCustomerKey = null, $fromCustomerKey = null)
    {
        $this
            ->setToCustomerID($toCustomerID)
            ->setFromCustomerID($fromCustomerID)
            ->setToCustomerKey($toCustomerKey)
            ->setFromCustomerKey($fromCustomerKey);
    }
    /**
     * Get ToCustomerID value
     * @return int
     */
    public function getToCustomerID()
    {
        return $this->ToCustomerID;
    }
    /**
     * Set ToCustomerID value
     * @param int $toCustomerID
     * @return \StructType\MergeCustomerRequest
     */
    public function setToCustomerID($toCustomerID = null)
    {
        // validation for constraint: int
        if (!is_null($toCustomerID) && !is_numeric($toCustomerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($toCustomerID)), __LINE__);
        }
        $this->ToCustomerID = $toCustomerID;
        return $this;
    }
    /**
     * Get FromCustomerID value
     * @return int
     */
    public function getFromCustomerID()
    {
        return $this->FromCustomerID;
    }
    /**
     * Set FromCustomerID value
     * @param int $fromCustomerID
     * @return \StructType\MergeCustomerRequest
     */
    public function setFromCustomerID($fromCustomerID = null)
    {
        // validation for constraint: int
        if (!is_null($fromCustomerID) && !is_numeric($fromCustomerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fromCustomerID)), __LINE__);
        }
        $this->FromCustomerID = $fromCustomerID;
        return $this;
    }
    /**
     * Get ToCustomerKey value
     * @return string|null
     */
    public function getToCustomerKey()
    {
        return $this->ToCustomerKey;
    }
    /**
     * Set ToCustomerKey value
     * @param string $toCustomerKey
     * @return \StructType\MergeCustomerRequest
     */
    public function setToCustomerKey($toCustomerKey = null)
    {
        // validation for constraint: string
        if (!is_null($toCustomerKey) && !is_string($toCustomerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toCustomerKey)), __LINE__);
        }
        $this->ToCustomerKey = $toCustomerKey;
        return $this;
    }
    /**
     * Get FromCustomerKey value
     * @return string|null
     */
    public function getFromCustomerKey()
    {
        return $this->FromCustomerKey;
    }
    /**
     * Set FromCustomerKey value
     * @param string $fromCustomerKey
     * @return \StructType\MergeCustomerRequest
     */
    public function setFromCustomerKey($fromCustomerKey = null)
    {
        // validation for constraint: string
        if (!is_null($fromCustomerKey) && !is_string($fromCustomerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromCustomerKey)), __LINE__);
        }
        $this->FromCustomerKey = $fromCustomerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MergeCustomerRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
