<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KitMemberResponse StructType
 * @subpackage Structs
 */
class KitMemberResponse extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The KitMemberItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfKitMemberItemResponse
     */
    public $KitMemberItems;
    /**
     * Constructor method for KitMemberResponse
     * @uses KitMemberResponse::setDescription()
     * @uses KitMemberResponse::setKitMemberItems()
     * @param string $description
     * @param \ArrayType\ArrayOfKitMemberItemResponse $kitMemberItems
     */
    public function __construct($description = null, \ArrayType\ArrayOfKitMemberItemResponse $kitMemberItems = null)
    {
        $this
            ->setDescription($description)
            ->setKitMemberItems($kitMemberItems);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\KitMemberResponse
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get KitMemberItems value
     * @return \ArrayType\ArrayOfKitMemberItemResponse|null
     */
    public function getKitMemberItems()
    {
        return $this->KitMemberItems;
    }
    /**
     * Set KitMemberItems value
     * @param \ArrayType\ArrayOfKitMemberItemResponse $kitMemberItems
     * @return \StructType\KitMemberResponse
     */
    public function setKitMemberItems(\ArrayType\ArrayOfKitMemberItemResponse $kitMemberItems = null)
    {
        $this->KitMemberItems = $kitMemberItems;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KitMemberResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
