<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KitMemberItemResponse StructType
 * @subpackage Structs
 */
class KitMemberItemResponse extends AbstractStructBase
{
    /**
     * The InventoryStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InventoryStatus;
    /**
     * The ItemCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for KitMemberItemResponse
     * @uses KitMemberItemResponse::setInventoryStatus()
     * @uses KitMemberItemResponse::setItemCode()
     * @uses KitMemberItemResponse::setDescription()
     * @param string $inventoryStatus
     * @param string $itemCode
     * @param string $description
     */
    public function __construct($inventoryStatus = null, $itemCode = null, $description = null)
    {
        $this
            ->setInventoryStatus($inventoryStatus)
            ->setItemCode($itemCode)
            ->setDescription($description);
    }
    /**
     * Get InventoryStatus value
     * @return string
     */
    public function getInventoryStatus()
    {
        return $this->InventoryStatus;
    }
    /**
     * Set InventoryStatus value
     * @uses \EnumType\InventoryStatusType::valueIsValid()
     * @uses \EnumType\InventoryStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $inventoryStatus
     * @return \StructType\KitMemberItemResponse
     */
    public function setInventoryStatus($inventoryStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InventoryStatusType::valueIsValid($inventoryStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $inventoryStatus, implode(', ', \EnumType\InventoryStatusType::getValidValues())), __LINE__);
        }
        $this->InventoryStatus = $inventoryStatus;
        return $this;
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \StructType\KitMemberItemResponse
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\KitMemberItemResponse
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KitMemberItemResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
