<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IsTaxIDAvailableValidateRequest StructType
 * @subpackage Structs
 */
class IsTaxIDAvailableValidateRequest extends ValidateRequest
{
    /**
     * The TaxTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TaxTypeID;
    /**
     * The ExcludeCustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExcludeCustomerID;
    /**
     * The TaxID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxID;
    /**
     * Constructor method for IsTaxIDAvailableValidateRequest
     * @uses IsTaxIDAvailableValidateRequest::setTaxTypeID()
     * @uses IsTaxIDAvailableValidateRequest::setExcludeCustomerID()
     * @uses IsTaxIDAvailableValidateRequest::setTaxID()
     * @param int $taxTypeID
     * @param int $excludeCustomerID
     * @param string $taxID
     */
    public function __construct($taxTypeID = null, $excludeCustomerID = null, $taxID = null)
    {
        $this
            ->setTaxTypeID($taxTypeID)
            ->setExcludeCustomerID($excludeCustomerID)
            ->setTaxID($taxID);
    }
    /**
     * Get TaxTypeID value
     * @return int
     */
    public function getTaxTypeID()
    {
        return $this->TaxTypeID;
    }
    /**
     * Set TaxTypeID value
     * @param int $taxTypeID
     * @return \StructType\IsTaxIDAvailableValidateRequest
     */
    public function setTaxTypeID($taxTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($taxTypeID) && !is_numeric($taxTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($taxTypeID)), __LINE__);
        }
        $this->TaxTypeID = $taxTypeID;
        return $this;
    }
    /**
     * Get ExcludeCustomerID value
     * @return int
     */
    public function getExcludeCustomerID()
    {
        return $this->ExcludeCustomerID;
    }
    /**
     * Set ExcludeCustomerID value
     * @param int $excludeCustomerID
     * @return \StructType\IsTaxIDAvailableValidateRequest
     */
    public function setExcludeCustomerID($excludeCustomerID = null)
    {
        // validation for constraint: int
        if (!is_null($excludeCustomerID) && !is_numeric($excludeCustomerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($excludeCustomerID)), __LINE__);
        }
        $this->ExcludeCustomerID = $excludeCustomerID;
        return $this;
    }
    /**
     * Get TaxID value
     * @return string|null
     */
    public function getTaxID()
    {
        return $this->TaxID;
    }
    /**
     * Set TaxID value
     * @param string $taxID
     * @return \StructType\IsTaxIDAvailableValidateRequest
     */
    public function setTaxID($taxID = null)
    {
        // validation for constraint: string
        if (!is_null($taxID) && !is_string($taxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxID)), __LINE__);
        }
        $this->TaxID = $taxID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IsTaxIDAvailableValidateRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
