<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVolumesRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetVolumesRequest
 * @subpackage Structs
 */
class GetVolumesRequest extends ApiRequest
{
    /**
     * The PeriodType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PeriodType;
    /**
     * The PeriodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PeriodID;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerID;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for GetVolumesRequest
     * @uses GetVolumesRequest::setPeriodType()
     * @uses GetVolumesRequest::setPeriodID()
     * @uses GetVolumesRequest::setCustomerID()
     * @uses GetVolumesRequest::setCustomerKey()
     * @param int $periodType
     * @param int $periodID
     * @param int $customerID
     * @param string $customerKey
     */
    public function __construct($periodType = null, $periodID = null, $customerID = null, $customerKey = null)
    {
        $this
            ->setPeriodType($periodType)
            ->setPeriodID($periodID)
            ->setCustomerID($customerID)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get PeriodType value
     * @return int
     */
    public function getPeriodType()
    {
        return $this->PeriodType;
    }
    /**
     * Set PeriodType value
     * @param int $periodType
     * @return \StructType\GetVolumesRequest
     */
    public function setPeriodType($periodType = null)
    {
        // validation for constraint: int
        if (!is_null($periodType) && !is_numeric($periodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodType)), __LINE__);
        }
        $this->PeriodType = $periodType;
        return $this;
    }
    /**
     * Get PeriodID value
     * @return int
     */
    public function getPeriodID()
    {
        return $this->PeriodID;
    }
    /**
     * Set PeriodID value
     * @param int $periodID
     * @return \StructType\GetVolumesRequest
     */
    public function setPeriodID($periodID = null)
    {
        // validation for constraint: int
        if (!is_null($periodID) && !is_numeric($periodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodID)), __LINE__);
        }
        $this->PeriodID = $periodID;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\GetVolumesRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\GetVolumesRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetVolumesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
