<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUserPermissionsResponse StructType
 * @subpackage Structs
 */
class GetUserPermissionsResponse extends ApiResponse
{
    /**
     * The ViewDeletedCustomers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ViewDeletedCustomers;
    /**
     * The AllowRemoteCheckPrint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AllowRemoteCheckPrint;
    /**
     * The AllowOverrideItemPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AllowOverrideItemPrice;
    /**
     * The AllowStatementPrint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AllowStatementPrint;
    /**
     * The DefaultWarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DefaultWarehouseID;
    /**
     * The LanguageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LanguageID;
    /**
     * The RestrictToCustomerTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $RestrictToCustomerTypes;
    /**
     * The RestrictToCustomerStatuses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $RestrictToCustomerStatuses;
    /**
     * The RestrictToWarehouses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $RestrictToWarehouses;
    /**
     * The RestrictToCountries
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $RestrictToCountries;
    /**
     * The RestrictToCurrencies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $RestrictToCurrencies;
    /**
     * The CultureCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CultureCode;
    /**
     * Constructor method for GetUserPermissionsResponse
     * @uses GetUserPermissionsResponse::setViewDeletedCustomers()
     * @uses GetUserPermissionsResponse::setAllowRemoteCheckPrint()
     * @uses GetUserPermissionsResponse::setAllowOverrideItemPrice()
     * @uses GetUserPermissionsResponse::setAllowStatementPrint()
     * @uses GetUserPermissionsResponse::setDefaultWarehouseID()
     * @uses GetUserPermissionsResponse::setLanguageID()
     * @uses GetUserPermissionsResponse::setRestrictToCustomerTypes()
     * @uses GetUserPermissionsResponse::setRestrictToCustomerStatuses()
     * @uses GetUserPermissionsResponse::setRestrictToWarehouses()
     * @uses GetUserPermissionsResponse::setRestrictToCountries()
     * @uses GetUserPermissionsResponse::setRestrictToCurrencies()
     * @uses GetUserPermissionsResponse::setCultureCode()
     * @param bool $viewDeletedCustomers
     * @param bool $allowRemoteCheckPrint
     * @param bool $allowOverrideItemPrice
     * @param bool $allowStatementPrint
     * @param int $defaultWarehouseID
     * @param int $languageID
     * @param \ArrayType\ArrayOfInt $restrictToCustomerTypes
     * @param \ArrayType\ArrayOfInt $restrictToCustomerStatuses
     * @param \ArrayType\ArrayOfInt $restrictToWarehouses
     * @param \ArrayType\ArrayOfString $restrictToCountries
     * @param \ArrayType\ArrayOfString $restrictToCurrencies
     * @param string $cultureCode
     */
    public function __construct($viewDeletedCustomers = null, $allowRemoteCheckPrint = null, $allowOverrideItemPrice = null, $allowStatementPrint = null, $defaultWarehouseID = null, $languageID = null, \ArrayType\ArrayOfInt $restrictToCustomerTypes = null, \ArrayType\ArrayOfInt $restrictToCustomerStatuses = null, \ArrayType\ArrayOfInt $restrictToWarehouses = null, \ArrayType\ArrayOfString $restrictToCountries = null, \ArrayType\ArrayOfString $restrictToCurrencies = null, $cultureCode = null)
    {
        $this
            ->setViewDeletedCustomers($viewDeletedCustomers)
            ->setAllowRemoteCheckPrint($allowRemoteCheckPrint)
            ->setAllowOverrideItemPrice($allowOverrideItemPrice)
            ->setAllowStatementPrint($allowStatementPrint)
            ->setDefaultWarehouseID($defaultWarehouseID)
            ->setLanguageID($languageID)
            ->setRestrictToCustomerTypes($restrictToCustomerTypes)
            ->setRestrictToCustomerStatuses($restrictToCustomerStatuses)
            ->setRestrictToWarehouses($restrictToWarehouses)
            ->setRestrictToCountries($restrictToCountries)
            ->setRestrictToCurrencies($restrictToCurrencies)
            ->setCultureCode($cultureCode);
    }
    /**
     * Get ViewDeletedCustomers value
     * @return bool
     */
    public function getViewDeletedCustomers()
    {
        return $this->ViewDeletedCustomers;
    }
    /**
     * Set ViewDeletedCustomers value
     * @param bool $viewDeletedCustomers
     * @return \StructType\GetUserPermissionsResponse
     */
    public function setViewDeletedCustomers($viewDeletedCustomers = null)
    {
        // validation for constraint: boolean
        if (!is_null($viewDeletedCustomers) && !is_bool($viewDeletedCustomers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($viewDeletedCustomers)), __LINE__);
        }
        $this->ViewDeletedCustomers = $viewDeletedCustomers;
        return $this;
    }
    /**
     * Get AllowRemoteCheckPrint value
     * @return bool
     */
    public function getAllowRemoteCheckPrint()
    {
        return $this->AllowRemoteCheckPrint;
    }
    /**
     * Set AllowRemoteCheckPrint value
     * @param bool $allowRemoteCheckPrint
     * @return \StructType\GetUserPermissionsResponse
     */
    public function setAllowRemoteCheckPrint($allowRemoteCheckPrint = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowRemoteCheckPrint) && !is_bool($allowRemoteCheckPrint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowRemoteCheckPrint)), __LINE__);
        }
        $this->AllowRemoteCheckPrint = $allowRemoteCheckPrint;
        return $this;
    }
    /**
     * Get AllowOverrideItemPrice value
     * @return bool
     */
    public function getAllowOverrideItemPrice()
    {
        return $this->AllowOverrideItemPrice;
    }
    /**
     * Set AllowOverrideItemPrice value
     * @param bool $allowOverrideItemPrice
     * @return \StructType\GetUserPermissionsResponse
     */
    public function setAllowOverrideItemPrice($allowOverrideItemPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowOverrideItemPrice) && !is_bool($allowOverrideItemPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowOverrideItemPrice)), __LINE__);
        }
        $this->AllowOverrideItemPrice = $allowOverrideItemPrice;
        return $this;
    }
    /**
     * Get AllowStatementPrint value
     * @return bool
     */
    public function getAllowStatementPrint()
    {
        return $this->AllowStatementPrint;
    }
    /**
     * Set AllowStatementPrint value
     * @param bool $allowStatementPrint
     * @return \StructType\GetUserPermissionsResponse
     */
    public function setAllowStatementPrint($allowStatementPrint = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowStatementPrint) && !is_bool($allowStatementPrint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowStatementPrint)), __LINE__);
        }
        $this->AllowStatementPrint = $allowStatementPrint;
        return $this;
    }
    /**
     * Get DefaultWarehouseID value
     * @return int
     */
    public function getDefaultWarehouseID()
    {
        return $this->DefaultWarehouseID;
    }
    /**
     * Set DefaultWarehouseID value
     * @param int $defaultWarehouseID
     * @return \StructType\GetUserPermissionsResponse
     */
    public function setDefaultWarehouseID($defaultWarehouseID = null)
    {
        // validation for constraint: int
        if (!is_null($defaultWarehouseID) && !is_numeric($defaultWarehouseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($defaultWarehouseID)), __LINE__);
        }
        $this->DefaultWarehouseID = $defaultWarehouseID;
        return $this;
    }
    /**
     * Get LanguageID value
     * @return int
     */
    public function getLanguageID()
    {
        return $this->LanguageID;
    }
    /**
     * Set LanguageID value
     * @param int $languageID
     * @return \StructType\GetUserPermissionsResponse
     */
    public function setLanguageID($languageID = null)
    {
        // validation for constraint: int
        if (!is_null($languageID) && !is_numeric($languageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($languageID)), __LINE__);
        }
        $this->LanguageID = $languageID;
        return $this;
    }
    /**
     * Get RestrictToCustomerTypes value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getRestrictToCustomerTypes()
    {
        return $this->RestrictToCustomerTypes;
    }
    /**
     * Set RestrictToCustomerTypes value
     * @param \ArrayType\ArrayOfInt $restrictToCustomerTypes
     * @return \StructType\GetUserPermissionsResponse
     */
    public function setRestrictToCustomerTypes(\ArrayType\ArrayOfInt $restrictToCustomerTypes = null)
    {
        $this->RestrictToCustomerTypes = $restrictToCustomerTypes;
        return $this;
    }
    /**
     * Get RestrictToCustomerStatuses value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getRestrictToCustomerStatuses()
    {
        return $this->RestrictToCustomerStatuses;
    }
    /**
     * Set RestrictToCustomerStatuses value
     * @param \ArrayType\ArrayOfInt $restrictToCustomerStatuses
     * @return \StructType\GetUserPermissionsResponse
     */
    public function setRestrictToCustomerStatuses(\ArrayType\ArrayOfInt $restrictToCustomerStatuses = null)
    {
        $this->RestrictToCustomerStatuses = $restrictToCustomerStatuses;
        return $this;
    }
    /**
     * Get RestrictToWarehouses value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getRestrictToWarehouses()
    {
        return $this->RestrictToWarehouses;
    }
    /**
     * Set RestrictToWarehouses value
     * @param \ArrayType\ArrayOfInt $restrictToWarehouses
     * @return \StructType\GetUserPermissionsResponse
     */
    public function setRestrictToWarehouses(\ArrayType\ArrayOfInt $restrictToWarehouses = null)
    {
        $this->RestrictToWarehouses = $restrictToWarehouses;
        return $this;
    }
    /**
     * Get RestrictToCountries value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getRestrictToCountries()
    {
        return $this->RestrictToCountries;
    }
    /**
     * Set RestrictToCountries value
     * @param \ArrayType\ArrayOfString $restrictToCountries
     * @return \StructType\GetUserPermissionsResponse
     */
    public function setRestrictToCountries(\ArrayType\ArrayOfString $restrictToCountries = null)
    {
        $this->RestrictToCountries = $restrictToCountries;
        return $this;
    }
    /**
     * Get RestrictToCurrencies value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getRestrictToCurrencies()
    {
        return $this->RestrictToCurrencies;
    }
    /**
     * Set RestrictToCurrencies value
     * @param \ArrayType\ArrayOfString $restrictToCurrencies
     * @return \StructType\GetUserPermissionsResponse
     */
    public function setRestrictToCurrencies(\ArrayType\ArrayOfString $restrictToCurrencies = null)
    {
        $this->RestrictToCurrencies = $restrictToCurrencies;
        return $this;
    }
    /**
     * Get CultureCode value
     * @return string|null
     */
    public function getCultureCode()
    {
        return $this->CultureCode;
    }
    /**
     * Set CultureCode value
     * @param string $cultureCode
     * @return \StructType\GetUserPermissionsResponse
     */
    public function setCultureCode($cultureCode = null)
    {
        // validation for constraint: string
        if (!is_null($cultureCode) && !is_string($cultureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cultureCode)), __LINE__);
        }
        $this->CultureCode = $cultureCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetUserPermissionsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
