<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSubscriptionRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetSubscriptionRequest
 * @subpackage Structs
 */
class GetSubscriptionRequest extends ApiRequest
{
    /**
     * The SubscriptionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SubscriptionID;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for GetSubscriptionRequest
     * @uses GetSubscriptionRequest::setSubscriptionID()
     * @uses GetSubscriptionRequest::setCustomerID()
     * @uses GetSubscriptionRequest::setCustomerKey()
     * @param int $subscriptionID
     * @param int $customerID
     * @param string $customerKey
     */
    public function __construct($subscriptionID = null, $customerID = null, $customerKey = null)
    {
        $this
            ->setSubscriptionID($subscriptionID)
            ->setCustomerID($customerID)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get SubscriptionID value
     * @return int
     */
    public function getSubscriptionID()
    {
        return $this->SubscriptionID;
    }
    /**
     * Set SubscriptionID value
     * @param int $subscriptionID
     * @return \StructType\GetSubscriptionRequest
     */
    public function setSubscriptionID($subscriptionID = null)
    {
        // validation for constraint: int
        if (!is_null($subscriptionID) && !is_numeric($subscriptionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($subscriptionID)), __LINE__);
        }
        $this->SubscriptionID = $subscriptionID;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\GetSubscriptionRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\GetSubscriptionRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSubscriptionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
