<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetShoppingCartRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetShoppingCartRequest
 * @subpackage Structs
 */
class GetShoppingCartRequest extends ApiRequest
{
    /**
     * The ShoppingID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShoppingID;
    /**
     * Constructor method for GetShoppingCartRequest
     * @uses GetShoppingCartRequest::setShoppingID()
     * @param string $shoppingID
     */
    public function __construct($shoppingID = null)
    {
        $this
            ->setShoppingID($shoppingID);
    }
    /**
     * Get ShoppingID value
     * @return string|null
     */
    public function getShoppingID()
    {
        return $this->ShoppingID;
    }
    /**
     * Set ShoppingID value
     * @param string $shoppingID
     * @return \StructType\GetShoppingCartRequest
     */
    public function setShoppingID($shoppingID = null)
    {
        // validation for constraint: string
        if (!is_null($shoppingID) && !is_string($shoppingID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shoppingID)), __LINE__);
        }
        $this->ShoppingID = $shoppingID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetShoppingCartRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
