<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSessionResponse StructType
 * @subpackage Structs
 */
class GetSessionResponse extends ApiResponse
{
    /**
     * The SessionData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SessionData;
    /**
     * Constructor method for GetSessionResponse
     * @uses GetSessionResponse::setSessionData()
     * @param string $sessionData
     */
    public function __construct($sessionData = null)
    {
        $this
            ->setSessionData($sessionData);
    }
    /**
     * Get SessionData value
     * @return string|null
     */
    public function getSessionData()
    {
        return $this->SessionData;
    }
    /**
     * Set SessionData value
     * @param string $sessionData
     * @return \StructType\GetSessionResponse
     */
    public function setSessionData($sessionData = null)
    {
        // validation for constraint: string
        if (!is_null($sessionData) && !is_string($sessionData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionData)), __LINE__);
        }
        $this->SessionData = $sessionData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSessionResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
