<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRealTimeCommissionDetailRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetRealTimeCommissionDetailRequest
 * @subpackage Structs
 */
class GetRealTimeCommissionDetailRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The PeriodType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PeriodType;
    /**
     * The PeriodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PeriodID;
    /**
     * The BonusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BonusID;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for GetRealTimeCommissionDetailRequest
     * @uses GetRealTimeCommissionDetailRequest::setCustomerID()
     * @uses GetRealTimeCommissionDetailRequest::setPeriodType()
     * @uses GetRealTimeCommissionDetailRequest::setPeriodID()
     * @uses GetRealTimeCommissionDetailRequest::setBonusID()
     * @uses GetRealTimeCommissionDetailRequest::setCustomerKey()
     * @param int $customerID
     * @param int $periodType
     * @param int $periodID
     * @param int $bonusID
     * @param string $customerKey
     */
    public function __construct($customerID = null, $periodType = null, $periodID = null, $bonusID = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setPeriodType($periodType)
            ->setPeriodID($periodID)
            ->setBonusID($bonusID)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\GetRealTimeCommissionDetailRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get PeriodType value
     * @return int
     */
    public function getPeriodType()
    {
        return $this->PeriodType;
    }
    /**
     * Set PeriodType value
     * @param int $periodType
     * @return \StructType\GetRealTimeCommissionDetailRequest
     */
    public function setPeriodType($periodType = null)
    {
        // validation for constraint: int
        if (!is_null($periodType) && !is_numeric($periodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodType)), __LINE__);
        }
        $this->PeriodType = $periodType;
        return $this;
    }
    /**
     * Get PeriodID value
     * @return int
     */
    public function getPeriodID()
    {
        return $this->PeriodID;
    }
    /**
     * Set PeriodID value
     * @param int $periodID
     * @return \StructType\GetRealTimeCommissionDetailRequest
     */
    public function setPeriodID($periodID = null)
    {
        // validation for constraint: int
        if (!is_null($periodID) && !is_numeric($periodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodID)), __LINE__);
        }
        $this->PeriodID = $periodID;
        return $this;
    }
    /**
     * Get BonusID value
     * @return int
     */
    public function getBonusID()
    {
        return $this->BonusID;
    }
    /**
     * Set BonusID value
     * @param int $bonusID
     * @return \StructType\GetRealTimeCommissionDetailRequest
     */
    public function setBonusID($bonusID = null)
    {
        // validation for constraint: int
        if (!is_null($bonusID) && !is_numeric($bonusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bonusID)), __LINE__);
        }
        $this->BonusID = $bonusID;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\GetRealTimeCommissionDetailRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRealTimeCommissionDetailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
