<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRankQualificationsRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetRankQualificationsRequest
 * @subpackage Structs
 */
class GetRankQualificationsRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The RankID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RankID;
    /**
     * The PeriodType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PeriodType;
    /**
     * The PeriodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PeriodID;
    /**
     * The RankGroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RankGroupID;
    /**
     * The CultureCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CultureCode;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for GetRankQualificationsRequest
     * @uses GetRankQualificationsRequest::setCustomerID()
     * @uses GetRankQualificationsRequest::setRankID()
     * @uses GetRankQualificationsRequest::setPeriodType()
     * @uses GetRankQualificationsRequest::setPeriodID()
     * @uses GetRankQualificationsRequest::setRankGroupID()
     * @uses GetRankQualificationsRequest::setCultureCode()
     * @uses GetRankQualificationsRequest::setCustomerKey()
     * @param int $customerID
     * @param int $rankID
     * @param int $periodType
     * @param int $periodID
     * @param int $rankGroupID
     * @param string $cultureCode
     * @param string $customerKey
     */
    public function __construct($customerID = null, $rankID = null, $periodType = null, $periodID = null, $rankGroupID = null, $cultureCode = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setRankID($rankID)
            ->setPeriodType($periodType)
            ->setPeriodID($periodID)
            ->setRankGroupID($rankGroupID)
            ->setCultureCode($cultureCode)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\GetRankQualificationsRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get RankID value
     * @return int
     */
    public function getRankID()
    {
        return $this->RankID;
    }
    /**
     * Set RankID value
     * @param int $rankID
     * @return \StructType\GetRankQualificationsRequest
     */
    public function setRankID($rankID = null)
    {
        // validation for constraint: int
        if (!is_null($rankID) && !is_numeric($rankID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rankID)), __LINE__);
        }
        $this->RankID = $rankID;
        return $this;
    }
    /**
     * Get PeriodType value
     * @return int
     */
    public function getPeriodType()
    {
        return $this->PeriodType;
    }
    /**
     * Set PeriodType value
     * @param int $periodType
     * @return \StructType\GetRankQualificationsRequest
     */
    public function setPeriodType($periodType = null)
    {
        // validation for constraint: int
        if (!is_null($periodType) && !is_numeric($periodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodType)), __LINE__);
        }
        $this->PeriodType = $periodType;
        return $this;
    }
    /**
     * Get PeriodID value
     * @return int
     */
    public function getPeriodID()
    {
        return $this->PeriodID;
    }
    /**
     * Set PeriodID value
     * @param int $periodID
     * @return \StructType\GetRankQualificationsRequest
     */
    public function setPeriodID($periodID = null)
    {
        // validation for constraint: int
        if (!is_null($periodID) && !is_numeric($periodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodID)), __LINE__);
        }
        $this->PeriodID = $periodID;
        return $this;
    }
    /**
     * Get RankGroupID value
     * @return int
     */
    public function getRankGroupID()
    {
        return $this->RankGroupID;
    }
    /**
     * Set RankGroupID value
     * @param int $rankGroupID
     * @return \StructType\GetRankQualificationsRequest
     */
    public function setRankGroupID($rankGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($rankGroupID) && !is_numeric($rankGroupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rankGroupID)), __LINE__);
        }
        $this->RankGroupID = $rankGroupID;
        return $this;
    }
    /**
     * Get CultureCode value
     * @return string|null
     */
    public function getCultureCode()
    {
        return $this->CultureCode;
    }
    /**
     * Set CultureCode value
     * @param string $cultureCode
     * @return \StructType\GetRankQualificationsRequest
     */
    public function setCultureCode($cultureCode = null)
    {
        // validation for constraint: string
        if (!is_null($cultureCode) && !is_string($cultureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cultureCode)), __LINE__);
        }
        $this->CultureCode = $cultureCode;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\GetRankQualificationsRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRankQualificationsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
