<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPointAccountRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetPointAccountRequest
 * @subpackage Structs
 */
class GetPointAccountRequest extends ApiRequest
{
    /**
     * The PointAccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PointAccountID;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for GetPointAccountRequest
     * @uses GetPointAccountRequest::setPointAccountID()
     * @uses GetPointAccountRequest::setCustomerID()
     * @uses GetPointAccountRequest::setCustomerKey()
     * @param int $pointAccountID
     * @param int $customerID
     * @param string $customerKey
     */
    public function __construct($pointAccountID = null, $customerID = null, $customerKey = null)
    {
        $this
            ->setPointAccountID($pointAccountID)
            ->setCustomerID($customerID)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get PointAccountID value
     * @return int
     */
    public function getPointAccountID()
    {
        return $this->PointAccountID;
    }
    /**
     * Set PointAccountID value
     * @param int $pointAccountID
     * @return \StructType\GetPointAccountRequest
     */
    public function setPointAccountID($pointAccountID = null)
    {
        // validation for constraint: int
        if (!is_null($pointAccountID) && !is_numeric($pointAccountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pointAccountID)), __LINE__);
        }
        $this->PointAccountID = $pointAccountID;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\GetPointAccountRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\GetPointAccountRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPointAccountRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
