<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetOrderTotalsResponse StructType
 * @subpackage Structs
 */
class GetOrderTotalsResponse extends ApiResponse
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The AcceptedByCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOrderTotalByCurrency
     */
    public $AcceptedByCurrency;
    /**
     * Constructor method for GetOrderTotalsResponse
     * @uses GetOrderTotalsResponse::setStartDate()
     * @uses GetOrderTotalsResponse::setEndDate()
     * @uses GetOrderTotalsResponse::setAcceptedByCurrency()
     * @param string $startDate
     * @param string $endDate
     * @param \ArrayType\ArrayOfOrderTotalByCurrency $acceptedByCurrency
     */
    public function __construct($startDate = null, $endDate = null, \ArrayType\ArrayOfOrderTotalByCurrency $acceptedByCurrency = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setAcceptedByCurrency($acceptedByCurrency);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\GetOrderTotalsResponse
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\GetOrderTotalsResponse
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get AcceptedByCurrency value
     * @return \ArrayType\ArrayOfOrderTotalByCurrency|null
     */
    public function getAcceptedByCurrency()
    {
        return $this->AcceptedByCurrency;
    }
    /**
     * Set AcceptedByCurrency value
     * @param \ArrayType\ArrayOfOrderTotalByCurrency $acceptedByCurrency
     * @return \StructType\GetOrderTotalsResponse
     */
    public function setAcceptedByCurrency(\ArrayType\ArrayOfOrderTotalByCurrency $acceptedByCurrency = null)
    {
        $this->AcceptedByCurrency = $acceptedByCurrency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetOrderTotalsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
