<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetOrderInvoiceRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetOrderInvoiceRequest
 * @subpackage Structs
 */
class GetOrderInvoiceRequest extends ApiRequest
{
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderID;
    /**
     * The ReportlayoutID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReportlayoutID;
    /**
     * The Format
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Format;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * Constructor method for GetOrderInvoiceRequest
     * @uses GetOrderInvoiceRequest::setOrderID()
     * @uses GetOrderInvoiceRequest::setReportlayoutID()
     * @uses GetOrderInvoiceRequest::setFormat()
     * @uses GetOrderInvoiceRequest::setOrderKey()
     * @param int $orderID
     * @param int $reportlayoutID
     * @param string $format
     * @param string $orderKey
     */
    public function __construct($orderID = null, $reportlayoutID = null, $format = null, $orderKey = null)
    {
        $this
            ->setOrderID($orderID)
            ->setReportlayoutID($reportlayoutID)
            ->setFormat($format)
            ->setOrderKey($orderKey);
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\GetOrderInvoiceRequest
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get ReportlayoutID value
     * @return int
     */
    public function getReportlayoutID()
    {
        return $this->ReportlayoutID;
    }
    /**
     * Set ReportlayoutID value
     * @param int $reportlayoutID
     * @return \StructType\GetOrderInvoiceRequest
     */
    public function setReportlayoutID($reportlayoutID = null)
    {
        // validation for constraint: int
        if (!is_null($reportlayoutID) && !is_numeric($reportlayoutID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reportlayoutID)), __LINE__);
        }
        $this->ReportlayoutID = $reportlayoutID;
        return $this;
    }
    /**
     * Get Format value
     * @return string
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @uses \EnumType\InvoiceRenderFormat::valueIsValid()
     * @uses \EnumType\InvoiceRenderFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \StructType\GetOrderInvoiceRequest
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InvoiceRenderFormat::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $format, implode(', ', \EnumType\InvoiceRenderFormat::getValidValues())), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\GetOrderInvoiceRequest
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetOrderInvoiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
