<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEmailAttachmentResponse StructType
 * @subpackage Structs
 */
class GetEmailAttachmentResponse extends ApiResponse
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The MailID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MailID;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * The Attachment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EmailAttachment
     */
    public $Attachment;
    /**
     * Constructor method for GetEmailAttachmentResponse
     * @uses GetEmailAttachmentResponse::setCustomerID()
     * @uses GetEmailAttachmentResponse::setMailID()
     * @uses GetEmailAttachmentResponse::setCustomerKey()
     * @uses GetEmailAttachmentResponse::setAttachment()
     * @param int $customerID
     * @param int $mailID
     * @param string $customerKey
     * @param \StructType\EmailAttachment $attachment
     */
    public function __construct($customerID = null, $mailID = null, $customerKey = null, \StructType\EmailAttachment $attachment = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setMailID($mailID)
            ->setCustomerKey($customerKey)
            ->setAttachment($attachment);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\GetEmailAttachmentResponse
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get MailID value
     * @return int
     */
    public function getMailID()
    {
        return $this->MailID;
    }
    /**
     * Set MailID value
     * @param int $mailID
     * @return \StructType\GetEmailAttachmentResponse
     */
    public function setMailID($mailID = null)
    {
        // validation for constraint: int
        if (!is_null($mailID) && !is_numeric($mailID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mailID)), __LINE__);
        }
        $this->MailID = $mailID;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\GetEmailAttachmentResponse
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Get Attachment value
     * @return \StructType\EmailAttachment|null
     */
    public function getAttachment()
    {
        return $this->Attachment;
    }
    /**
     * Set Attachment value
     * @param \StructType\EmailAttachment $attachment
     * @return \StructType\GetEmailAttachmentResponse
     */
    public function setAttachment(\StructType\EmailAttachment $attachment = null)
    {
        $this->Attachment = $attachment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetEmailAttachmentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
