<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCompanyNewsRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetCompanyNewsRequest
 * @subpackage Structs
 */
class GetCompanyNewsRequest extends ApiRequest
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The DepartmentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DepartmentType;
    /**
     * Constructor method for GetCompanyNewsRequest
     * @uses GetCompanyNewsRequest::setStartDate()
     * @uses GetCompanyNewsRequest::setEndDate()
     * @uses GetCompanyNewsRequest::setDepartmentType()
     * @param string $startDate
     * @param string $endDate
     * @param int $departmentType
     */
    public function __construct($startDate = null, $endDate = null, $departmentType = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setDepartmentType($departmentType);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\GetCompanyNewsRequest
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\GetCompanyNewsRequest
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get DepartmentType value
     * @return int
     */
    public function getDepartmentType()
    {
        return $this->DepartmentType;
    }
    /**
     * Set DepartmentType value
     * @param int $departmentType
     * @return \StructType\GetCompanyNewsRequest
     */
    public function setDepartmentType($departmentType = null)
    {
        // validation for constraint: int
        if (!is_null($departmentType) && !is_numeric($departmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($departmentType)), __LINE__);
        }
        $this->DepartmentType = $departmentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCompanyNewsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
