<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCommissionReportRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetCommissionReportRequest
 * @subpackage Structs
 */
class GetCommissionReportRequest extends ApiRequest
{
    /**
     * The PeriodType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PeriodType;
    /**
     * The PeriodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PeriodID;
    /**
     * The ReportName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReportName;
    /**
     * The ParameterData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParameterData;
    /**
     * Constructor method for GetCommissionReportRequest
     * @uses GetCommissionReportRequest::setPeriodType()
     * @uses GetCommissionReportRequest::setPeriodID()
     * @uses GetCommissionReportRequest::setReportName()
     * @uses GetCommissionReportRequest::setParameterData()
     * @param int $periodType
     * @param int $periodID
     * @param string $reportName
     * @param string $parameterData
     */
    public function __construct($periodType = null, $periodID = null, $reportName = null, $parameterData = null)
    {
        $this
            ->setPeriodType($periodType)
            ->setPeriodID($periodID)
            ->setReportName($reportName)
            ->setParameterData($parameterData);
    }
    /**
     * Get PeriodType value
     * @return int
     */
    public function getPeriodType()
    {
        return $this->PeriodType;
    }
    /**
     * Set PeriodType value
     * @param int $periodType
     * @return \StructType\GetCommissionReportRequest
     */
    public function setPeriodType($periodType = null)
    {
        // validation for constraint: int
        if (!is_null($periodType) && !is_numeric($periodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodType)), __LINE__);
        }
        $this->PeriodType = $periodType;
        return $this;
    }
    /**
     * Get PeriodID value
     * @return int
     */
    public function getPeriodID()
    {
        return $this->PeriodID;
    }
    /**
     * Set PeriodID value
     * @param int $periodID
     * @return \StructType\GetCommissionReportRequest
     */
    public function setPeriodID($periodID = null)
    {
        // validation for constraint: int
        if (!is_null($periodID) && !is_numeric($periodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodID)), __LINE__);
        }
        $this->PeriodID = $periodID;
        return $this;
    }
    /**
     * Get ReportName value
     * @return string|null
     */
    public function getReportName()
    {
        return $this->ReportName;
    }
    /**
     * Set ReportName value
     * @param string $reportName
     * @return \StructType\GetCommissionReportRequest
     */
    public function setReportName($reportName = null)
    {
        // validation for constraint: string
        if (!is_null($reportName) && !is_string($reportName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reportName)), __LINE__);
        }
        $this->ReportName = $reportName;
        return $this;
    }
    /**
     * Get ParameterData value
     * @return string|null
     */
    public function getParameterData()
    {
        return $this->ParameterData;
    }
    /**
     * Set ParameterData value
     * @param string $parameterData
     * @return \StructType\GetCommissionReportRequest
     */
    public function setParameterData($parameterData = null)
    {
        // validation for constraint: string
        if (!is_null($parameterData) && !is_string($parameterData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parameterData)), __LINE__);
        }
        $this->ParameterData = $parameterData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCommissionReportRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
