<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAutoOrdersRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetAutoOrdersRequest
 * @subpackage Structs
 */
class GetAutoOrdersRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The AutoOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AutoOrderID;
    /**
     * The AutoOrderStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AutoOrderStatus;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for GetAutoOrdersRequest
     * @uses GetAutoOrdersRequest::setCustomerID()
     * @uses GetAutoOrdersRequest::setAutoOrderID()
     * @uses GetAutoOrdersRequest::setAutoOrderStatus()
     * @uses GetAutoOrdersRequest::setCustomerKey()
     * @param int $customerID
     * @param int $autoOrderID
     * @param string $autoOrderStatus
     * @param string $customerKey
     */
    public function __construct($customerID = null, $autoOrderID = null, $autoOrderStatus = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setAutoOrderID($autoOrderID)
            ->setAutoOrderStatus($autoOrderStatus)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\GetAutoOrdersRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get AutoOrderID value
     * @return int
     */
    public function getAutoOrderID()
    {
        return $this->AutoOrderID;
    }
    /**
     * Set AutoOrderID value
     * @param int $autoOrderID
     * @return \StructType\GetAutoOrdersRequest
     */
    public function setAutoOrderID($autoOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($autoOrderID) && !is_numeric($autoOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($autoOrderID)), __LINE__);
        }
        $this->AutoOrderID = $autoOrderID;
        return $this;
    }
    /**
     * Get AutoOrderStatus value
     * @return string
     */
    public function getAutoOrderStatus()
    {
        return $this->AutoOrderStatus;
    }
    /**
     * Set AutoOrderStatus value
     * @uses \EnumType\AutoOrderStatusType::valueIsValid()
     * @uses \EnumType\AutoOrderStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $autoOrderStatus
     * @return \StructType\GetAutoOrdersRequest
     */
    public function setAutoOrderStatus($autoOrderStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AutoOrderStatusType::valueIsValid($autoOrderStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $autoOrderStatus, implode(', ', \EnumType\AutoOrderStatusType::getValidValues())), __LINE__);
        }
        $this->AutoOrderStatus = $autoOrderStatus;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\GetAutoOrdersRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAutoOrdersRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
