<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountDirectDepositResponse StructType
 * @subpackage Structs
 */
class GetAccountDirectDepositResponse extends ApiResponse
{
    /**
     * The DepositAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepositAccountType;
    /**
     * The BankAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BankAccountType;
    /**
     * The NameOnAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameOnAccount;
    /**
     * The BankAccountNumberDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountNumberDisplay;
    /**
     * The BankRoutingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankRoutingNumber;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankName;
    /**
     * The BankAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAddress;
    /**
     * The BankCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankCity;
    /**
     * The BankState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankState;
    /**
     * The BankZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankZip;
    /**
     * The BankCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankCountry;
    /**
     * The Iban
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Iban;
    /**
     * The SwiftCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SwiftCode;
    /**
     * Constructor method for GetAccountDirectDepositResponse
     * @uses GetAccountDirectDepositResponse::setDepositAccountType()
     * @uses GetAccountDirectDepositResponse::setBankAccountType()
     * @uses GetAccountDirectDepositResponse::setNameOnAccount()
     * @uses GetAccountDirectDepositResponse::setBankAccountNumberDisplay()
     * @uses GetAccountDirectDepositResponse::setBankRoutingNumber()
     * @uses GetAccountDirectDepositResponse::setBankName()
     * @uses GetAccountDirectDepositResponse::setBankAddress()
     * @uses GetAccountDirectDepositResponse::setBankCity()
     * @uses GetAccountDirectDepositResponse::setBankState()
     * @uses GetAccountDirectDepositResponse::setBankZip()
     * @uses GetAccountDirectDepositResponse::setBankCountry()
     * @uses GetAccountDirectDepositResponse::setIban()
     * @uses GetAccountDirectDepositResponse::setSwiftCode()
     * @param string $depositAccountType
     * @param string $bankAccountType
     * @param string $nameOnAccount
     * @param string $bankAccountNumberDisplay
     * @param string $bankRoutingNumber
     * @param string $bankName
     * @param string $bankAddress
     * @param string $bankCity
     * @param string $bankState
     * @param string $bankZip
     * @param string $bankCountry
     * @param string $iban
     * @param string $swiftCode
     */
    public function __construct($depositAccountType = null, $bankAccountType = null, $nameOnAccount = null, $bankAccountNumberDisplay = null, $bankRoutingNumber = null, $bankName = null, $bankAddress = null, $bankCity = null, $bankState = null, $bankZip = null, $bankCountry = null, $iban = null, $swiftCode = null)
    {
        $this
            ->setDepositAccountType($depositAccountType)
            ->setBankAccountType($bankAccountType)
            ->setNameOnAccount($nameOnAccount)
            ->setBankAccountNumberDisplay($bankAccountNumberDisplay)
            ->setBankRoutingNumber($bankRoutingNumber)
            ->setBankName($bankName)
            ->setBankAddress($bankAddress)
            ->setBankCity($bankCity)
            ->setBankState($bankState)
            ->setBankZip($bankZip)
            ->setBankCountry($bankCountry)
            ->setIban($iban)
            ->setSwiftCode($swiftCode);
    }
    /**
     * Get DepositAccountType value
     * @return string
     */
    public function getDepositAccountType()
    {
        return $this->DepositAccountType;
    }
    /**
     * Set DepositAccountType value
     * @uses \EnumType\DepositAccountType::valueIsValid()
     * @uses \EnumType\DepositAccountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $depositAccountType
     * @return \StructType\GetAccountDirectDepositResponse
     */
    public function setDepositAccountType($depositAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DepositAccountType::valueIsValid($depositAccountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $depositAccountType, implode(', ', \EnumType\DepositAccountType::getValidValues())), __LINE__);
        }
        $this->DepositAccountType = $depositAccountType;
        return $this;
    }
    /**
     * Get BankAccountType value
     * @return string
     */
    public function getBankAccountType()
    {
        return $this->BankAccountType;
    }
    /**
     * Set BankAccountType value
     * @uses \EnumType\BankAccountType::valueIsValid()
     * @uses \EnumType\BankAccountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bankAccountType
     * @return \StructType\GetAccountDirectDepositResponse
     */
    public function setBankAccountType($bankAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BankAccountType::valueIsValid($bankAccountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bankAccountType, implode(', ', \EnumType\BankAccountType::getValidValues())), __LINE__);
        }
        $this->BankAccountType = $bankAccountType;
        return $this;
    }
    /**
     * Get NameOnAccount value
     * @return string|null
     */
    public function getNameOnAccount()
    {
        return $this->NameOnAccount;
    }
    /**
     * Set NameOnAccount value
     * @param string $nameOnAccount
     * @return \StructType\GetAccountDirectDepositResponse
     */
    public function setNameOnAccount($nameOnAccount = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnAccount) && !is_string($nameOnAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameOnAccount)), __LINE__);
        }
        $this->NameOnAccount = $nameOnAccount;
        return $this;
    }
    /**
     * Get BankAccountNumberDisplay value
     * @return string|null
     */
    public function getBankAccountNumberDisplay()
    {
        return $this->BankAccountNumberDisplay;
    }
    /**
     * Set BankAccountNumberDisplay value
     * @param string $bankAccountNumberDisplay
     * @return \StructType\GetAccountDirectDepositResponse
     */
    public function setBankAccountNumberDisplay($bankAccountNumberDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountNumberDisplay) && !is_string($bankAccountNumberDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAccountNumberDisplay)), __LINE__);
        }
        $this->BankAccountNumberDisplay = $bankAccountNumberDisplay;
        return $this;
    }
    /**
     * Get BankRoutingNumber value
     * @return string|null
     */
    public function getBankRoutingNumber()
    {
        return $this->BankRoutingNumber;
    }
    /**
     * Set BankRoutingNumber value
     * @param string $bankRoutingNumber
     * @return \StructType\GetAccountDirectDepositResponse
     */
    public function setBankRoutingNumber($bankRoutingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankRoutingNumber) && !is_string($bankRoutingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankRoutingNumber)), __LINE__);
        }
        $this->BankRoutingNumber = $bankRoutingNumber;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \StructType\GetAccountDirectDepositResponse
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get BankAddress value
     * @return string|null
     */
    public function getBankAddress()
    {
        return $this->BankAddress;
    }
    /**
     * Set BankAddress value
     * @param string $bankAddress
     * @return \StructType\GetAccountDirectDepositResponse
     */
    public function setBankAddress($bankAddress = null)
    {
        // validation for constraint: string
        if (!is_null($bankAddress) && !is_string($bankAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAddress)), __LINE__);
        }
        $this->BankAddress = $bankAddress;
        return $this;
    }
    /**
     * Get BankCity value
     * @return string|null
     */
    public function getBankCity()
    {
        return $this->BankCity;
    }
    /**
     * Set BankCity value
     * @param string $bankCity
     * @return \StructType\GetAccountDirectDepositResponse
     */
    public function setBankCity($bankCity = null)
    {
        // validation for constraint: string
        if (!is_null($bankCity) && !is_string($bankCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankCity)), __LINE__);
        }
        $this->BankCity = $bankCity;
        return $this;
    }
    /**
     * Get BankState value
     * @return string|null
     */
    public function getBankState()
    {
        return $this->BankState;
    }
    /**
     * Set BankState value
     * @param string $bankState
     * @return \StructType\GetAccountDirectDepositResponse
     */
    public function setBankState($bankState = null)
    {
        // validation for constraint: string
        if (!is_null($bankState) && !is_string($bankState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankState)), __LINE__);
        }
        $this->BankState = $bankState;
        return $this;
    }
    /**
     * Get BankZip value
     * @return string|null
     */
    public function getBankZip()
    {
        return $this->BankZip;
    }
    /**
     * Set BankZip value
     * @param string $bankZip
     * @return \StructType\GetAccountDirectDepositResponse
     */
    public function setBankZip($bankZip = null)
    {
        // validation for constraint: string
        if (!is_null($bankZip) && !is_string($bankZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankZip)), __LINE__);
        }
        $this->BankZip = $bankZip;
        return $this;
    }
    /**
     * Get BankCountry value
     * @return string|null
     */
    public function getBankCountry()
    {
        return $this->BankCountry;
    }
    /**
     * Set BankCountry value
     * @param string $bankCountry
     * @return \StructType\GetAccountDirectDepositResponse
     */
    public function setBankCountry($bankCountry = null)
    {
        // validation for constraint: string
        if (!is_null($bankCountry) && !is_string($bankCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankCountry)), __LINE__);
        }
        $this->BankCountry = $bankCountry;
        return $this;
    }
    /**
     * Get Iban value
     * @return string|null
     */
    public function getIban()
    {
        return $this->Iban;
    }
    /**
     * Set Iban value
     * @param string $iban
     * @return \StructType\GetAccountDirectDepositResponse
     */
    public function setIban($iban = null)
    {
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iban)), __LINE__);
        }
        $this->Iban = $iban;
        return $this;
    }
    /**
     * Get SwiftCode value
     * @return string|null
     */
    public function getSwiftCode()
    {
        return $this->SwiftCode;
    }
    /**
     * Set SwiftCode value
     * @param string $swiftCode
     * @return \StructType\GetAccountDirectDepositResponse
     */
    public function setSwiftCode($swiftCode = null)
    {
        // validation for constraint: string
        if (!is_null($swiftCode) && !is_string($swiftCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($swiftCode)), __LINE__);
        }
        $this->SwiftCode = $swiftCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountDirectDepositResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
