<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FundPaymentCardRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:FundPaymentCardRequest
 * @subpackage Structs
 */
class FundPaymentCardRequest extends BaseCreatePayoutRequest
{
    /**
     * The PaymentCardTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentCardTypeID;
    /**
     * The BillIDList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $BillIDList;
    /**
     * Constructor method for FundPaymentCardRequest
     * @uses FundPaymentCardRequest::setPaymentCardTypeID()
     * @uses FundPaymentCardRequest::setBillIDList()
     * @param int $paymentCardTypeID
     * @param \ArrayType\ArrayOfInt $billIDList
     */
    public function __construct($paymentCardTypeID = null, \ArrayType\ArrayOfInt $billIDList = null)
    {
        $this
            ->setPaymentCardTypeID($paymentCardTypeID)
            ->setBillIDList($billIDList);
    }
    /**
     * Get PaymentCardTypeID value
     * @return int
     */
    public function getPaymentCardTypeID()
    {
        return $this->PaymentCardTypeID;
    }
    /**
     * Set PaymentCardTypeID value
     * @param int $paymentCardTypeID
     * @return \StructType\FundPaymentCardRequest
     */
    public function setPaymentCardTypeID($paymentCardTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentCardTypeID) && !is_numeric($paymentCardTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentCardTypeID)), __LINE__);
        }
        $this->PaymentCardTypeID = $paymentCardTypeID;
        return $this;
    }
    /**
     * Get BillIDList value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getBillIDList()
    {
        return $this->BillIDList;
    }
    /**
     * Set BillIDList value
     * @param \ArrayType\ArrayOfInt $billIDList
     * @return \StructType\FundPaymentCardRequest
     */
    public function setBillIDList(\ArrayType\ArrayOfInt $billIDList = null)
    {
        $this->BillIDList = $billIDList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FundPaymentCardRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
