<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteQualificationOverrideRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:DeleteQualificationOverrideRequest
 * @subpackage Structs
 */
class DeleteQualificationOverrideRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The OverrideID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OverrideID;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for DeleteQualificationOverrideRequest
     * @uses DeleteQualificationOverrideRequest::setCustomerID()
     * @uses DeleteQualificationOverrideRequest::setOverrideID()
     * @uses DeleteQualificationOverrideRequest::setCustomerKey()
     * @param int $customerID
     * @param int $overrideID
     * @param string $customerKey
     */
    public function __construct($customerID = null, $overrideID = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setOverrideID($overrideID)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\DeleteQualificationOverrideRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get OverrideID value
     * @return int
     */
    public function getOverrideID()
    {
        return $this->OverrideID;
    }
    /**
     * Set OverrideID value
     * @param int $overrideID
     * @return \StructType\DeleteQualificationOverrideRequest
     */
    public function setOverrideID($overrideID = null)
    {
        // validation for constraint: int
        if (!is_null($overrideID) && !is_numeric($overrideID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($overrideID)), __LINE__);
        }
        $this->OverrideID = $overrideID;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\DeleteQualificationOverrideRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteQualificationOverrideRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
