<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteEntityResponse StructType
 * @subpackage Structs
 */
class DeleteEntityResponse extends ApiResponse
{
    /**
     * The schemaName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $schemaName;
    /**
     * The EntityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntityName;
    /**
     * Constructor method for DeleteEntityResponse
     * @uses DeleteEntityResponse::setSchemaName()
     * @uses DeleteEntityResponse::setEntityName()
     * @param string $schemaName
     * @param string $entityName
     */
    public function __construct($schemaName = null, $entityName = null)
    {
        $this
            ->setSchemaName($schemaName)
            ->setEntityName($entityName);
    }
    /**
     * Get schemaName value
     * @return string|null
     */
    public function getSchemaName()
    {
        return $this->schemaName;
    }
    /**
     * Set schemaName value
     * @param string $schemaName
     * @return \StructType\DeleteEntityResponse
     */
    public function setSchemaName($schemaName = null)
    {
        // validation for constraint: string
        if (!is_null($schemaName) && !is_string($schemaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($schemaName)), __LINE__);
        }
        $this->schemaName = $schemaName;
        return $this;
    }
    /**
     * Get EntityName value
     * @return string|null
     */
    public function getEntityName()
    {
        return $this->EntityName;
    }
    /**
     * Set EntityName value
     * @param string $entityName
     * @return \StructType\DeleteEntityResponse
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityName)), __LINE__);
        }
        $this->EntityName = $entityName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteEntityResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
