<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteCustomerExtendedRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:DeleteCustomerExtendedRequest
 * @subpackage Structs
 */
class DeleteCustomerExtendedRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The ExtendedGroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExtendedGroupID;
    /**
     * The CustomerExtendedID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerExtendedID;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for DeleteCustomerExtendedRequest
     * @uses DeleteCustomerExtendedRequest::setCustomerID()
     * @uses DeleteCustomerExtendedRequest::setExtendedGroupID()
     * @uses DeleteCustomerExtendedRequest::setCustomerExtendedID()
     * @uses DeleteCustomerExtendedRequest::setCustomerKey()
     * @param int $customerID
     * @param int $extendedGroupID
     * @param int $customerExtendedID
     * @param string $customerKey
     */
    public function __construct($customerID = null, $extendedGroupID = null, $customerExtendedID = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setExtendedGroupID($extendedGroupID)
            ->setCustomerExtendedID($customerExtendedID)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\DeleteCustomerExtendedRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get ExtendedGroupID value
     * @return int
     */
    public function getExtendedGroupID()
    {
        return $this->ExtendedGroupID;
    }
    /**
     * Set ExtendedGroupID value
     * @param int $extendedGroupID
     * @return \StructType\DeleteCustomerExtendedRequest
     */
    public function setExtendedGroupID($extendedGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($extendedGroupID) && !is_numeric($extendedGroupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($extendedGroupID)), __LINE__);
        }
        $this->ExtendedGroupID = $extendedGroupID;
        return $this;
    }
    /**
     * Get CustomerExtendedID value
     * @return int
     */
    public function getCustomerExtendedID()
    {
        return $this->CustomerExtendedID;
    }
    /**
     * Set CustomerExtendedID value
     * @param int $customerExtendedID
     * @return \StructType\DeleteCustomerExtendedRequest
     */
    public function setCustomerExtendedID($customerExtendedID = null)
    {
        // validation for constraint: int
        if (!is_null($customerExtendedID) && !is_numeric($customerExtendedID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerExtendedID)), __LINE__);
        }
        $this->CustomerExtendedID = $customerExtendedID;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\DeleteCustomerExtendedRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteCustomerExtendedRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
