<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerBalanceResponse StructType
 * @subpackage Structs
 */
class CustomerBalanceResponse extends AbstractStructBase
{
    /**
     * The Balance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Balance;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The CurrencyDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyDescription;
    /**
     * Constructor method for CustomerBalanceResponse
     * @uses CustomerBalanceResponse::setBalance()
     * @uses CustomerBalanceResponse::setCurrencyCode()
     * @uses CustomerBalanceResponse::setCurrencyDescription()
     * @param float $balance
     * @param string $currencyCode
     * @param string $currencyDescription
     */
    public function __construct($balance = null, $currencyCode = null, $currencyDescription = null)
    {
        $this
            ->setBalance($balance)
            ->setCurrencyCode($currencyCode)
            ->setCurrencyDescription($currencyDescription);
    }
    /**
     * Get Balance value
     * @return float
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \StructType\CustomerBalanceResponse
     */
    public function setBalance($balance = null)
    {
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CustomerBalanceResponse
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get CurrencyDescription value
     * @return string|null
     */
    public function getCurrencyDescription()
    {
        return $this->CurrencyDescription;
    }
    /**
     * Set CurrencyDescription value
     * @param string $currencyDescription
     * @return \StructType\CustomerBalanceResponse
     */
    public function setCurrencyDescription($currencyDescription = null)
    {
        // validation for constraint: string
        if (!is_null($currencyDescription) && !is_string($currencyDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyDescription)), __LINE__);
        }
        $this->CurrencyDescription = $currencyDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerBalanceResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
