<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardAccountResponse StructType
 * @subpackage Structs
 */
class CreditCardAccountResponse extends AbstractStructBase
{
    /**
     * The ExpirationMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpirationMonth;
    /**
     * The ExpirationYear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpirationYear;
    /**
     * The CreditCardType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CreditCardType;
    /**
     * The CreditCardNumberDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditCardNumberDisplay;
    /**
     * The CreditCardTypeDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditCardTypeDescription;
    /**
     * The BillingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingName;
    /**
     * The BillingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingAddress;
    /**
     * The BillingCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCity;
    /**
     * The BillingState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingState;
    /**
     * The BillingZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingZip;
    /**
     * The BillingCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCountry;
    /**
     * The BillingAddress2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingAddress2;
    /**
     * Constructor method for CreditCardAccountResponse
     * @uses CreditCardAccountResponse::setExpirationMonth()
     * @uses CreditCardAccountResponse::setExpirationYear()
     * @uses CreditCardAccountResponse::setCreditCardType()
     * @uses CreditCardAccountResponse::setCreditCardNumberDisplay()
     * @uses CreditCardAccountResponse::setCreditCardTypeDescription()
     * @uses CreditCardAccountResponse::setBillingName()
     * @uses CreditCardAccountResponse::setBillingAddress()
     * @uses CreditCardAccountResponse::setBillingCity()
     * @uses CreditCardAccountResponse::setBillingState()
     * @uses CreditCardAccountResponse::setBillingZip()
     * @uses CreditCardAccountResponse::setBillingCountry()
     * @uses CreditCardAccountResponse::setBillingAddress2()
     * @param int $expirationMonth
     * @param int $expirationYear
     * @param int $creditCardType
     * @param string $creditCardNumberDisplay
     * @param string $creditCardTypeDescription
     * @param string $billingName
     * @param string $billingAddress
     * @param string $billingCity
     * @param string $billingState
     * @param string $billingZip
     * @param string $billingCountry
     * @param string $billingAddress2
     */
    public function __construct($expirationMonth = null, $expirationYear = null, $creditCardType = null, $creditCardNumberDisplay = null, $creditCardTypeDescription = null, $billingName = null, $billingAddress = null, $billingCity = null, $billingState = null, $billingZip = null, $billingCountry = null, $billingAddress2 = null)
    {
        $this
            ->setExpirationMonth($expirationMonth)
            ->setExpirationYear($expirationYear)
            ->setCreditCardType($creditCardType)
            ->setCreditCardNumberDisplay($creditCardNumberDisplay)
            ->setCreditCardTypeDescription($creditCardTypeDescription)
            ->setBillingName($billingName)
            ->setBillingAddress($billingAddress)
            ->setBillingCity($billingCity)
            ->setBillingState($billingState)
            ->setBillingZip($billingZip)
            ->setBillingCountry($billingCountry)
            ->setBillingAddress2($billingAddress2);
    }
    /**
     * Get ExpirationMonth value
     * @return int
     */
    public function getExpirationMonth()
    {
        return $this->ExpirationMonth;
    }
    /**
     * Set ExpirationMonth value
     * @param int $expirationMonth
     * @return \StructType\CreditCardAccountResponse
     */
    public function setExpirationMonth($expirationMonth = null)
    {
        // validation for constraint: int
        if (!is_null($expirationMonth) && !is_numeric($expirationMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expirationMonth)), __LINE__);
        }
        $this->ExpirationMonth = $expirationMonth;
        return $this;
    }
    /**
     * Get ExpirationYear value
     * @return int
     */
    public function getExpirationYear()
    {
        return $this->ExpirationYear;
    }
    /**
     * Set ExpirationYear value
     * @param int $expirationYear
     * @return \StructType\CreditCardAccountResponse
     */
    public function setExpirationYear($expirationYear = null)
    {
        // validation for constraint: int
        if (!is_null($expirationYear) && !is_numeric($expirationYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expirationYear)), __LINE__);
        }
        $this->ExpirationYear = $expirationYear;
        return $this;
    }
    /**
     * Get CreditCardType value
     * @return int
     */
    public function getCreditCardType()
    {
        return $this->CreditCardType;
    }
    /**
     * Set CreditCardType value
     * @param int $creditCardType
     * @return \StructType\CreditCardAccountResponse
     */
    public function setCreditCardType($creditCardType = null)
    {
        // validation for constraint: int
        if (!is_null($creditCardType) && !is_numeric($creditCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($creditCardType)), __LINE__);
        }
        $this->CreditCardType = $creditCardType;
        return $this;
    }
    /**
     * Get CreditCardNumberDisplay value
     * @return string|null
     */
    public function getCreditCardNumberDisplay()
    {
        return $this->CreditCardNumberDisplay;
    }
    /**
     * Set CreditCardNumberDisplay value
     * @param string $creditCardNumberDisplay
     * @return \StructType\CreditCardAccountResponse
     */
    public function setCreditCardNumberDisplay($creditCardNumberDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardNumberDisplay) && !is_string($creditCardNumberDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditCardNumberDisplay)), __LINE__);
        }
        $this->CreditCardNumberDisplay = $creditCardNumberDisplay;
        return $this;
    }
    /**
     * Get CreditCardTypeDescription value
     * @return string|null
     */
    public function getCreditCardTypeDescription()
    {
        return $this->CreditCardTypeDescription;
    }
    /**
     * Set CreditCardTypeDescription value
     * @param string $creditCardTypeDescription
     * @return \StructType\CreditCardAccountResponse
     */
    public function setCreditCardTypeDescription($creditCardTypeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardTypeDescription) && !is_string($creditCardTypeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditCardTypeDescription)), __LINE__);
        }
        $this->CreditCardTypeDescription = $creditCardTypeDescription;
        return $this;
    }
    /**
     * Get BillingName value
     * @return string|null
     */
    public function getBillingName()
    {
        return $this->BillingName;
    }
    /**
     * Set BillingName value
     * @param string $billingName
     * @return \StructType\CreditCardAccountResponse
     */
    public function setBillingName($billingName = null)
    {
        // validation for constraint: string
        if (!is_null($billingName) && !is_string($billingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingName)), __LINE__);
        }
        $this->BillingName = $billingName;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return string|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param string $billingAddress
     * @return \StructType\CreditCardAccountResponse
     */
    public function setBillingAddress($billingAddress = null)
    {
        // validation for constraint: string
        if (!is_null($billingAddress) && !is_string($billingAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingAddress)), __LINE__);
        }
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get BillingCity value
     * @return string|null
     */
    public function getBillingCity()
    {
        return $this->BillingCity;
    }
    /**
     * Set BillingCity value
     * @param string $billingCity
     * @return \StructType\CreditCardAccountResponse
     */
    public function setBillingCity($billingCity = null)
    {
        // validation for constraint: string
        if (!is_null($billingCity) && !is_string($billingCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCity)), __LINE__);
        }
        $this->BillingCity = $billingCity;
        return $this;
    }
    /**
     * Get BillingState value
     * @return string|null
     */
    public function getBillingState()
    {
        return $this->BillingState;
    }
    /**
     * Set BillingState value
     * @param string $billingState
     * @return \StructType\CreditCardAccountResponse
     */
    public function setBillingState($billingState = null)
    {
        // validation for constraint: string
        if (!is_null($billingState) && !is_string($billingState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingState)), __LINE__);
        }
        $this->BillingState = $billingState;
        return $this;
    }
    /**
     * Get BillingZip value
     * @return string|null
     */
    public function getBillingZip()
    {
        return $this->BillingZip;
    }
    /**
     * Set BillingZip value
     * @param string $billingZip
     * @return \StructType\CreditCardAccountResponse
     */
    public function setBillingZip($billingZip = null)
    {
        // validation for constraint: string
        if (!is_null($billingZip) && !is_string($billingZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingZip)), __LINE__);
        }
        $this->BillingZip = $billingZip;
        return $this;
    }
    /**
     * Get BillingCountry value
     * @return string|null
     */
    public function getBillingCountry()
    {
        return $this->BillingCountry;
    }
    /**
     * Set BillingCountry value
     * @param string $billingCountry
     * @return \StructType\CreditCardAccountResponse
     */
    public function setBillingCountry($billingCountry = null)
    {
        // validation for constraint: string
        if (!is_null($billingCountry) && !is_string($billingCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCountry)), __LINE__);
        }
        $this->BillingCountry = $billingCountry;
        return $this;
    }
    /**
     * Get BillingAddress2 value
     * @return string|null
     */
    public function getBillingAddress2()
    {
        return $this->BillingAddress2;
    }
    /**
     * Set BillingAddress2 value
     * @param string $billingAddress2
     * @return \StructType\CreditCardAccountResponse
     */
    public function setBillingAddress2($billingAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($billingAddress2) && !is_string($billingAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingAddress2)), __LINE__);
        }
        $this->BillingAddress2 = $billingAddress2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreditCardAccountResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
