<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePayoutRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:CreatePayoutRequest
 * @subpackage Structs
 */
class CreatePayoutRequest extends BaseCreatePayoutRequest
{
    /**
     * The VendorPaymentTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VendorPaymentTypeID;
    /**
     * The BillIDs_ToPay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $BillIDs_ToPay;
    /**
     * Constructor method for CreatePayoutRequest
     * @uses CreatePayoutRequest::setVendorPaymentTypeID()
     * @uses CreatePayoutRequest::setBillIDs_ToPay()
     * @param int $vendorPaymentTypeID
     * @param \ArrayType\ArrayOfInt $billIDs_ToPay
     */
    public function __construct($vendorPaymentTypeID = null, \ArrayType\ArrayOfInt $billIDs_ToPay = null)
    {
        $this
            ->setVendorPaymentTypeID($vendorPaymentTypeID)
            ->setBillIDs_ToPay($billIDs_ToPay);
    }
    /**
     * Get VendorPaymentTypeID value
     * @return int
     */
    public function getVendorPaymentTypeID()
    {
        return $this->VendorPaymentTypeID;
    }
    /**
     * Set VendorPaymentTypeID value
     * @param int $vendorPaymentTypeID
     * @return \StructType\CreatePayoutRequest
     */
    public function setVendorPaymentTypeID($vendorPaymentTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($vendorPaymentTypeID) && !is_numeric($vendorPaymentTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vendorPaymentTypeID)), __LINE__);
        }
        $this->VendorPaymentTypeID = $vendorPaymentTypeID;
        return $this;
    }
    /**
     * Get BillIDs_ToPay value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getBillIDs_ToPay()
    {
        return $this->BillIDs_ToPay;
    }
    /**
     * Set BillIDs_ToPay value
     * @param \ArrayType\ArrayOfInt $billIDs_ToPay
     * @return \StructType\CreatePayoutRequest
     */
    public function setBillIDs_ToPay(\ArrayType\ArrayOfInt $billIDs_ToPay = null)
    {
        $this->BillIDs_ToPay = $billIDs_ToPay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreatePayoutRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
