<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePaymentCheckRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:CreatePaymentCheckRequest
 * @subpackage Structs
 */
class CreatePaymentCheckRequest extends BaseCreatePaymentRequest
{
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderID;
    /**
     * The PaymentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentDate;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The CheckDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CheckDate;
    /**
     * The Memo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The CheckNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckNumber;
    /**
     * The CheckAccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckAccountNumber;
    /**
     * The CheckRoutingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckRoutingNumber;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * Constructor method for CreatePaymentCheckRequest
     * @uses CreatePaymentCheckRequest::setOrderID()
     * @uses CreatePaymentCheckRequest::setPaymentDate()
     * @uses CreatePaymentCheckRequest::setAmount()
     * @uses CreatePaymentCheckRequest::setCheckDate()
     * @uses CreatePaymentCheckRequest::setMemo()
     * @uses CreatePaymentCheckRequest::setCheckNumber()
     * @uses CreatePaymentCheckRequest::setCheckAccountNumber()
     * @uses CreatePaymentCheckRequest::setCheckRoutingNumber()
     * @uses CreatePaymentCheckRequest::setOrderKey()
     * @param int $orderID
     * @param string $paymentDate
     * @param float $amount
     * @param string $checkDate
     * @param string $memo
     * @param string $checkNumber
     * @param string $checkAccountNumber
     * @param string $checkRoutingNumber
     * @param string $orderKey
     */
    public function __construct($orderID = null, $paymentDate = null, $amount = null, $checkDate = null, $memo = null, $checkNumber = null, $checkAccountNumber = null, $checkRoutingNumber = null, $orderKey = null)
    {
        $this
            ->setOrderID($orderID)
            ->setPaymentDate($paymentDate)
            ->setAmount($amount)
            ->setCheckDate($checkDate)
            ->setMemo($memo)
            ->setCheckNumber($checkNumber)
            ->setCheckAccountNumber($checkAccountNumber)
            ->setCheckRoutingNumber($checkRoutingNumber)
            ->setOrderKey($orderKey);
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\CreatePaymentCheckRequest
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \StructType\CreatePaymentCheckRequest
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\CreatePaymentCheckRequest
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CheckDate value
     * @return string
     */
    public function getCheckDate()
    {
        return $this->CheckDate;
    }
    /**
     * Set CheckDate value
     * @param string $checkDate
     * @return \StructType\CreatePaymentCheckRequest
     */
    public function setCheckDate($checkDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkDate) && !is_string($checkDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkDate)), __LINE__);
        }
        $this->CheckDate = $checkDate;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\CreatePaymentCheckRequest
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get CheckNumber value
     * @return string|null
     */
    public function getCheckNumber()
    {
        return $this->CheckNumber;
    }
    /**
     * Set CheckNumber value
     * @param string $checkNumber
     * @return \StructType\CreatePaymentCheckRequest
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: string
        if (!is_null($checkNumber) && !is_string($checkNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkNumber)), __LINE__);
        }
        $this->CheckNumber = $checkNumber;
        return $this;
    }
    /**
     * Get CheckAccountNumber value
     * @return string|null
     */
    public function getCheckAccountNumber()
    {
        return $this->CheckAccountNumber;
    }
    /**
     * Set CheckAccountNumber value
     * @param string $checkAccountNumber
     * @return \StructType\CreatePaymentCheckRequest
     */
    public function setCheckAccountNumber($checkAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($checkAccountNumber) && !is_string($checkAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkAccountNumber)), __LINE__);
        }
        $this->CheckAccountNumber = $checkAccountNumber;
        return $this;
    }
    /**
     * Get CheckRoutingNumber value
     * @return string|null
     */
    public function getCheckRoutingNumber()
    {
        return $this->CheckRoutingNumber;
    }
    /**
     * Set CheckRoutingNumber value
     * @param string $checkRoutingNumber
     * @return \StructType\CreatePaymentCheckRequest
     */
    public function setCheckRoutingNumber($checkRoutingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($checkRoutingNumber) && !is_string($checkRoutingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkRoutingNumber)), __LINE__);
        }
        $this->CheckRoutingNumber = $checkRoutingNumber;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\CreatePaymentCheckRequest
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreatePaymentCheckRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
