<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateExpectedCODResponse StructType
 * @subpackage Structs
 */
class CreateExpectedCODResponse extends BaseCreateExpectedPaymentResponse
{
    /**
     * The ExpectedPaymentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpectedPaymentID;
    /**
     * Constructor method for CreateExpectedCODResponse
     * @uses CreateExpectedCODResponse::setExpectedPaymentID()
     * @param int $expectedPaymentID
     */
    public function __construct($expectedPaymentID = null)
    {
        $this
            ->setExpectedPaymentID($expectedPaymentID);
    }
    /**
     * Get ExpectedPaymentID value
     * @return int
     */
    public function getExpectedPaymentID()
    {
        return $this->ExpectedPaymentID;
    }
    /**
     * Set ExpectedPaymentID value
     * @param int $expectedPaymentID
     * @return \StructType\CreateExpectedCODResponse
     */
    public function setExpectedPaymentID($expectedPaymentID = null)
    {
        // validation for constraint: int
        if (!is_null($expectedPaymentID) && !is_numeric($expectedPaymentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expectedPaymentID)), __LINE__);
        }
        $this->ExpectedPaymentID = $expectedPaymentID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateExpectedCODResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
