<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateCustomerWallItemResponse StructType
 * @subpackage Structs
 */
class CreateCustomerWallItemResponse extends ApiResponse
{
    /**
     * The WallItemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WallItemID;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for CreateCustomerWallItemResponse
     * @uses CreateCustomerWallItemResponse::setWallItemID()
     * @uses CreateCustomerWallItemResponse::setCustomerID()
     * @uses CreateCustomerWallItemResponse::setCustomerKey()
     * @param int $wallItemID
     * @param int $customerID
     * @param string $customerKey
     */
    public function __construct($wallItemID = null, $customerID = null, $customerKey = null)
    {
        $this
            ->setWallItemID($wallItemID)
            ->setCustomerID($customerID)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get WallItemID value
     * @return int
     */
    public function getWallItemID()
    {
        return $this->WallItemID;
    }
    /**
     * Set WallItemID value
     * @param int $wallItemID
     * @return \StructType\CreateCustomerWallItemResponse
     */
    public function setWallItemID($wallItemID = null)
    {
        // validation for constraint: int
        if (!is_null($wallItemID) && !is_numeric($wallItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($wallItemID)), __LINE__);
        }
        $this->WallItemID = $wallItemID;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\CreateCustomerWallItemResponse
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\CreateCustomerWallItemResponse
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateCustomerWallItemResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
