<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionResponse StructType
 * @subpackage Structs
 */
class CommissionResponse extends AbstractStructBase
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The PeriodType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PeriodType;
    /**
     * The PeriodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PeriodID;
    /**
     * The CommissionTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CommissionTotal;
    /**
     * The PeriodDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PeriodDescription;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Bonuses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCommissionBonusResponse
     */
    public $Bonuses;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for CommissionResponse
     * @uses CommissionResponse::setCustomerID()
     * @uses CommissionResponse::setPeriodType()
     * @uses CommissionResponse::setPeriodID()
     * @uses CommissionResponse::setCommissionTotal()
     * @uses CommissionResponse::setPeriodDescription()
     * @uses CommissionResponse::setCurrencyCode()
     * @uses CommissionResponse::setBonuses()
     * @uses CommissionResponse::setCustomerKey()
     * @param int $customerID
     * @param int $periodType
     * @param int $periodID
     * @param float $commissionTotal
     * @param string $periodDescription
     * @param string $currencyCode
     * @param \ArrayType\ArrayOfCommissionBonusResponse $bonuses
     * @param string $customerKey
     */
    public function __construct($customerID = null, $periodType = null, $periodID = null, $commissionTotal = null, $periodDescription = null, $currencyCode = null, \ArrayType\ArrayOfCommissionBonusResponse $bonuses = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setPeriodType($periodType)
            ->setPeriodID($periodID)
            ->setCommissionTotal($commissionTotal)
            ->setPeriodDescription($periodDescription)
            ->setCurrencyCode($currencyCode)
            ->setBonuses($bonuses)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\CommissionResponse
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get PeriodType value
     * @return int
     */
    public function getPeriodType()
    {
        return $this->PeriodType;
    }
    /**
     * Set PeriodType value
     * @param int $periodType
     * @return \StructType\CommissionResponse
     */
    public function setPeriodType($periodType = null)
    {
        // validation for constraint: int
        if (!is_null($periodType) && !is_numeric($periodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodType)), __LINE__);
        }
        $this->PeriodType = $periodType;
        return $this;
    }
    /**
     * Get PeriodID value
     * @return int
     */
    public function getPeriodID()
    {
        return $this->PeriodID;
    }
    /**
     * Set PeriodID value
     * @param int $periodID
     * @return \StructType\CommissionResponse
     */
    public function setPeriodID($periodID = null)
    {
        // validation for constraint: int
        if (!is_null($periodID) && !is_numeric($periodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($periodID)), __LINE__);
        }
        $this->PeriodID = $periodID;
        return $this;
    }
    /**
     * Get CommissionTotal value
     * @return float
     */
    public function getCommissionTotal()
    {
        return $this->CommissionTotal;
    }
    /**
     * Set CommissionTotal value
     * @param float $commissionTotal
     * @return \StructType\CommissionResponse
     */
    public function setCommissionTotal($commissionTotal = null)
    {
        $this->CommissionTotal = $commissionTotal;
        return $this;
    }
    /**
     * Get PeriodDescription value
     * @return string|null
     */
    public function getPeriodDescription()
    {
        return $this->PeriodDescription;
    }
    /**
     * Set PeriodDescription value
     * @param string $periodDescription
     * @return \StructType\CommissionResponse
     */
    public function setPeriodDescription($periodDescription = null)
    {
        // validation for constraint: string
        if (!is_null($periodDescription) && !is_string($periodDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodDescription)), __LINE__);
        }
        $this->PeriodDescription = $periodDescription;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\CommissionResponse
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Bonuses value
     * @return \ArrayType\ArrayOfCommissionBonusResponse|null
     */
    public function getBonuses()
    {
        return $this->Bonuses;
    }
    /**
     * Set Bonuses value
     * @param \ArrayType\ArrayOfCommissionBonusResponse $bonuses
     * @return \StructType\CommissionResponse
     */
    public function setBonuses(\ArrayType\ArrayOfCommissionBonusResponse $bonuses = null)
    {
        $this->Bonuses = $bonuses;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\CommissionResponse
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommissionResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
