<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionDetailResponse StructType
 * @subpackage Structs
 */
class CommissionDetailResponse extends AbstractStructBase
{
    /**
     * The FromCustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FromCustomerID;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderID;
    /**
     * The Level
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Level;
    /**
     * The PaidLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaidLevel;
    /**
     * The SourceAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SourceAmount;
    /**
     * The Percentage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Percentage;
    /**
     * The CommissionAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CommissionAmount;
    /**
     * The FromCustomerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromCustomerName;
    /**
     * The FromCustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromCustomerKey;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * Constructor method for CommissionDetailResponse
     * @uses CommissionDetailResponse::setFromCustomerID()
     * @uses CommissionDetailResponse::setOrderID()
     * @uses CommissionDetailResponse::setLevel()
     * @uses CommissionDetailResponse::setPaidLevel()
     * @uses CommissionDetailResponse::setSourceAmount()
     * @uses CommissionDetailResponse::setPercentage()
     * @uses CommissionDetailResponse::setCommissionAmount()
     * @uses CommissionDetailResponse::setFromCustomerName()
     * @uses CommissionDetailResponse::setFromCustomerKey()
     * @uses CommissionDetailResponse::setOrderKey()
     * @param int $fromCustomerID
     * @param int $orderID
     * @param int $level
     * @param int $paidLevel
     * @param float $sourceAmount
     * @param float $percentage
     * @param float $commissionAmount
     * @param string $fromCustomerName
     * @param string $fromCustomerKey
     * @param string $orderKey
     */
    public function __construct($fromCustomerID = null, $orderID = null, $level = null, $paidLevel = null, $sourceAmount = null, $percentage = null, $commissionAmount = null, $fromCustomerName = null, $fromCustomerKey = null, $orderKey = null)
    {
        $this
            ->setFromCustomerID($fromCustomerID)
            ->setOrderID($orderID)
            ->setLevel($level)
            ->setPaidLevel($paidLevel)
            ->setSourceAmount($sourceAmount)
            ->setPercentage($percentage)
            ->setCommissionAmount($commissionAmount)
            ->setFromCustomerName($fromCustomerName)
            ->setFromCustomerKey($fromCustomerKey)
            ->setOrderKey($orderKey);
    }
    /**
     * Get FromCustomerID value
     * @return int
     */
    public function getFromCustomerID()
    {
        return $this->FromCustomerID;
    }
    /**
     * Set FromCustomerID value
     * @param int $fromCustomerID
     * @return \StructType\CommissionDetailResponse
     */
    public function setFromCustomerID($fromCustomerID = null)
    {
        // validation for constraint: int
        if (!is_null($fromCustomerID) && !is_numeric($fromCustomerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fromCustomerID)), __LINE__);
        }
        $this->FromCustomerID = $fromCustomerID;
        return $this;
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\CommissionDetailResponse
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get Level value
     * @return int
     */
    public function getLevel()
    {
        return $this->Level;
    }
    /**
     * Set Level value
     * @param int $level
     * @return \StructType\CommissionDetailResponse
     */
    public function setLevel($level = null)
    {
        // validation for constraint: int
        if (!is_null($level) && !is_numeric($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($level)), __LINE__);
        }
        $this->Level = $level;
        return $this;
    }
    /**
     * Get PaidLevel value
     * @return int
     */
    public function getPaidLevel()
    {
        return $this->PaidLevel;
    }
    /**
     * Set PaidLevel value
     * @param int $paidLevel
     * @return \StructType\CommissionDetailResponse
     */
    public function setPaidLevel($paidLevel = null)
    {
        // validation for constraint: int
        if (!is_null($paidLevel) && !is_numeric($paidLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paidLevel)), __LINE__);
        }
        $this->PaidLevel = $paidLevel;
        return $this;
    }
    /**
     * Get SourceAmount value
     * @return float
     */
    public function getSourceAmount()
    {
        return $this->SourceAmount;
    }
    /**
     * Set SourceAmount value
     * @param float $sourceAmount
     * @return \StructType\CommissionDetailResponse
     */
    public function setSourceAmount($sourceAmount = null)
    {
        $this->SourceAmount = $sourceAmount;
        return $this;
    }
    /**
     * Get Percentage value
     * @return float
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param float $percentage
     * @return \StructType\CommissionDetailResponse
     */
    public function setPercentage($percentage = null)
    {
        $this->Percentage = $percentage;
        return $this;
    }
    /**
     * Get CommissionAmount value
     * @return float
     */
    public function getCommissionAmount()
    {
        return $this->CommissionAmount;
    }
    /**
     * Set CommissionAmount value
     * @param float $commissionAmount
     * @return \StructType\CommissionDetailResponse
     */
    public function setCommissionAmount($commissionAmount = null)
    {
        $this->CommissionAmount = $commissionAmount;
        return $this;
    }
    /**
     * Get FromCustomerName value
     * @return string|null
     */
    public function getFromCustomerName()
    {
        return $this->FromCustomerName;
    }
    /**
     * Set FromCustomerName value
     * @param string $fromCustomerName
     * @return \StructType\CommissionDetailResponse
     */
    public function setFromCustomerName($fromCustomerName = null)
    {
        // validation for constraint: string
        if (!is_null($fromCustomerName) && !is_string($fromCustomerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromCustomerName)), __LINE__);
        }
        $this->FromCustomerName = $fromCustomerName;
        return $this;
    }
    /**
     * Get FromCustomerKey value
     * @return string|null
     */
    public function getFromCustomerKey()
    {
        return $this->FromCustomerKey;
    }
    /**
     * Set FromCustomerKey value
     * @param string $fromCustomerKey
     * @return \StructType\CommissionDetailResponse
     */
    public function setFromCustomerKey($fromCustomerKey = null)
    {
        // validation for constraint: string
        if (!is_null($fromCustomerKey) && !is_string($fromCustomerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromCustomerKey)), __LINE__);
        }
        $this->FromCustomerKey = $fromCustomerKey;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\CommissionDetailResponse
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommissionDetailResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
