<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionBonusResponse StructType
 * @subpackage Structs
 */
class CommissionBonusResponse extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The BonusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BonusID;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for CommissionBonusResponse
     * @uses CommissionBonusResponse::setAmount()
     * @uses CommissionBonusResponse::setBonusID()
     * @uses CommissionBonusResponse::setDescription()
     * @param float $amount
     * @param int $bonusID
     * @param string $description
     */
    public function __construct($amount = null, $bonusID = null, $description = null)
    {
        $this
            ->setAmount($amount)
            ->setBonusID($bonusID)
            ->setDescription($description);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\CommissionBonusResponse
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get BonusID value
     * @return int
     */
    public function getBonusID()
    {
        return $this->BonusID;
    }
    /**
     * Set BonusID value
     * @param int $bonusID
     * @return \StructType\CommissionBonusResponse
     */
    public function setBonusID($bonusID = null)
    {
        // validation for constraint: int
        if (!is_null($bonusID) && !is_numeric($bonusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bonusID)), __LINE__);
        }
        $this->BonusID = $bonusID;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\CommissionBonusResponse
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommissionBonusResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
