<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeWalletAccountRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:ChargeWalletAccountRequest
 * @subpackage Structs
 */
class ChargeWalletAccountRequest extends BaseChargeWalletAccountRequest
{
    /**
     * The WalletTy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WalletTy;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderID;
    /**
     * The MaxAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxAmount;
    /**
     * The WalletAccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WalletAccountNumber;
    /**
     * The Memo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * Constructor method for ChargeWalletAccountRequest
     * @uses ChargeWalletAccountRequest::setWalletTy()
     * @uses ChargeWalletAccountRequest::setOrderID()
     * @uses ChargeWalletAccountRequest::setMaxAmount()
     * @uses ChargeWalletAccountRequest::setWalletAccountNumber()
     * @uses ChargeWalletAccountRequest::setMemo()
     * @uses ChargeWalletAccountRequest::setOrderKey()
     * @param int $walletTy
     * @param int $orderID
     * @param float $maxAmount
     * @param string $walletAccountNumber
     * @param string $memo
     * @param string $orderKey
     */
    public function __construct($walletTy = null, $orderID = null, $maxAmount = null, $walletAccountNumber = null, $memo = null, $orderKey = null)
    {
        $this
            ->setWalletTy($walletTy)
            ->setOrderID($orderID)
            ->setMaxAmount($maxAmount)
            ->setWalletAccountNumber($walletAccountNumber)
            ->setMemo($memo)
            ->setOrderKey($orderKey);
    }
    /**
     * Get WalletTy value
     * @return int
     */
    public function getWalletTy()
    {
        return $this->WalletTy;
    }
    /**
     * Set WalletTy value
     * @param int $walletTy
     * @return \StructType\ChargeWalletAccountRequest
     */
    public function setWalletTy($walletTy = null)
    {
        // validation for constraint: int
        if (!is_null($walletTy) && !is_numeric($walletTy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($walletTy)), __LINE__);
        }
        $this->WalletTy = $walletTy;
        return $this;
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\ChargeWalletAccountRequest
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get MaxAmount value
     * @return float
     */
    public function getMaxAmount()
    {
        return $this->MaxAmount;
    }
    /**
     * Set MaxAmount value
     * @param float $maxAmount
     * @return \StructType\ChargeWalletAccountRequest
     */
    public function setMaxAmount($maxAmount = null)
    {
        $this->MaxAmount = $maxAmount;
        return $this;
    }
    /**
     * Get WalletAccountNumber value
     * @return string|null
     */
    public function getWalletAccountNumber()
    {
        return $this->WalletAccountNumber;
    }
    /**
     * Set WalletAccountNumber value
     * @param string $walletAccountNumber
     * @return \StructType\ChargeWalletAccountRequest
     */
    public function setWalletAccountNumber($walletAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($walletAccountNumber) && !is_string($walletAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($walletAccountNumber)), __LINE__);
        }
        $this->WalletAccountNumber = $walletAccountNumber;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\ChargeWalletAccountRequest
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\ChargeWalletAccountRequest
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChargeWalletAccountRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
