<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeCreditCardTokenRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:ChargeCreditCardTokenRequest
 * @subpackage Structs
 */
class ChargeCreditCardTokenRequest extends BaseChargeCreditCardRequest
{
    /**
     * The CreditCardType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CreditCardType;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderID;
    /**
     * The MaxAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxAmount;
    /**
     * The MerchantWarehouseIDOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MerchantWarehouseIDOverride;
    /**
     * The CreditCardToken
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditCardToken;
    /**
     * The BillingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingName;
    /**
     * The BillingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingAddress;
    /**
     * The BillingAddress2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingAddress2;
    /**
     * The BillingCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCity;
    /**
     * The BillingState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingState;
    /**
     * The BillingZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingZip;
    /**
     * The BillingCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCountry;
    /**
     * The CvcCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CvcCode;
    /**
     * The IssueNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueNumber;
    /**
     * The ClientIPAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientIPAddress;
    /**
     * The OtherData1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData1;
    /**
     * The OtherData2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData2;
    /**
     * The OtherData3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData3;
    /**
     * The OtherData4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData4;
    /**
     * The OtherData5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData5;
    /**
     * The OtherData6
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData6;
    /**
     * The OtherData7
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData7;
    /**
     * The OtherData8
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData8;
    /**
     * The OtherData9
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData9;
    /**
     * The OtherData10
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherData10;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * Constructor method for ChargeCreditCardTokenRequest
     * @uses ChargeCreditCardTokenRequest::setCreditCardType()
     * @uses ChargeCreditCardTokenRequest::setOrderID()
     * @uses ChargeCreditCardTokenRequest::setMaxAmount()
     * @uses ChargeCreditCardTokenRequest::setMerchantWarehouseIDOverride()
     * @uses ChargeCreditCardTokenRequest::setCreditCardToken()
     * @uses ChargeCreditCardTokenRequest::setBillingName()
     * @uses ChargeCreditCardTokenRequest::setBillingAddress()
     * @uses ChargeCreditCardTokenRequest::setBillingAddress2()
     * @uses ChargeCreditCardTokenRequest::setBillingCity()
     * @uses ChargeCreditCardTokenRequest::setBillingState()
     * @uses ChargeCreditCardTokenRequest::setBillingZip()
     * @uses ChargeCreditCardTokenRequest::setBillingCountry()
     * @uses ChargeCreditCardTokenRequest::setCvcCode()
     * @uses ChargeCreditCardTokenRequest::setIssueNumber()
     * @uses ChargeCreditCardTokenRequest::setClientIPAddress()
     * @uses ChargeCreditCardTokenRequest::setOtherData1()
     * @uses ChargeCreditCardTokenRequest::setOtherData2()
     * @uses ChargeCreditCardTokenRequest::setOtherData3()
     * @uses ChargeCreditCardTokenRequest::setOtherData4()
     * @uses ChargeCreditCardTokenRequest::setOtherData5()
     * @uses ChargeCreditCardTokenRequest::setOtherData6()
     * @uses ChargeCreditCardTokenRequest::setOtherData7()
     * @uses ChargeCreditCardTokenRequest::setOtherData8()
     * @uses ChargeCreditCardTokenRequest::setOtherData9()
     * @uses ChargeCreditCardTokenRequest::setOtherData10()
     * @uses ChargeCreditCardTokenRequest::setOrderKey()
     * @param int $creditCardType
     * @param int $orderID
     * @param float $maxAmount
     * @param int $merchantWarehouseIDOverride
     * @param string $creditCardToken
     * @param string $billingName
     * @param string $billingAddress
     * @param string $billingAddress2
     * @param string $billingCity
     * @param string $billingState
     * @param string $billingZip
     * @param string $billingCountry
     * @param string $cvcCode
     * @param string $issueNumber
     * @param string $clientIPAddress
     * @param string $otherData1
     * @param string $otherData2
     * @param string $otherData3
     * @param string $otherData4
     * @param string $otherData5
     * @param string $otherData6
     * @param string $otherData7
     * @param string $otherData8
     * @param string $otherData9
     * @param string $otherData10
     * @param string $orderKey
     */
    public function __construct($creditCardType = null, $orderID = null, $maxAmount = null, $merchantWarehouseIDOverride = null, $creditCardToken = null, $billingName = null, $billingAddress = null, $billingAddress2 = null, $billingCity = null, $billingState = null, $billingZip = null, $billingCountry = null, $cvcCode = null, $issueNumber = null, $clientIPAddress = null, $otherData1 = null, $otherData2 = null, $otherData3 = null, $otherData4 = null, $otherData5 = null, $otherData6 = null, $otherData7 = null, $otherData8 = null, $otherData9 = null, $otherData10 = null, $orderKey = null)
    {
        $this
            ->setCreditCardType($creditCardType)
            ->setOrderID($orderID)
            ->setMaxAmount($maxAmount)
            ->setMerchantWarehouseIDOverride($merchantWarehouseIDOverride)
            ->setCreditCardToken($creditCardToken)
            ->setBillingName($billingName)
            ->setBillingAddress($billingAddress)
            ->setBillingAddress2($billingAddress2)
            ->setBillingCity($billingCity)
            ->setBillingState($billingState)
            ->setBillingZip($billingZip)
            ->setBillingCountry($billingCountry)
            ->setCvcCode($cvcCode)
            ->setIssueNumber($issueNumber)
            ->setClientIPAddress($clientIPAddress)
            ->setOtherData1($otherData1)
            ->setOtherData2($otherData2)
            ->setOtherData3($otherData3)
            ->setOtherData4($otherData4)
            ->setOtherData5($otherData5)
            ->setOtherData6($otherData6)
            ->setOtherData7($otherData7)
            ->setOtherData8($otherData8)
            ->setOtherData9($otherData9)
            ->setOtherData10($otherData10)
            ->setOrderKey($orderKey);
    }
    /**
     * Get CreditCardType value
     * @return int
     */
    public function getCreditCardType()
    {
        return $this->CreditCardType;
    }
    /**
     * Set CreditCardType value
     * @param int $creditCardType
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setCreditCardType($creditCardType = null)
    {
        // validation for constraint: int
        if (!is_null($creditCardType) && !is_numeric($creditCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($creditCardType)), __LINE__);
        }
        $this->CreditCardType = $creditCardType;
        return $this;
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get MaxAmount value
     * @return float
     */
    public function getMaxAmount()
    {
        return $this->MaxAmount;
    }
    /**
     * Set MaxAmount value
     * @param float $maxAmount
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setMaxAmount($maxAmount = null)
    {
        $this->MaxAmount = $maxAmount;
        return $this;
    }
    /**
     * Get MerchantWarehouseIDOverride value
     * @return int
     */
    public function getMerchantWarehouseIDOverride()
    {
        return $this->MerchantWarehouseIDOverride;
    }
    /**
     * Set MerchantWarehouseIDOverride value
     * @param int $merchantWarehouseIDOverride
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setMerchantWarehouseIDOverride($merchantWarehouseIDOverride = null)
    {
        // validation for constraint: int
        if (!is_null($merchantWarehouseIDOverride) && !is_numeric($merchantWarehouseIDOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($merchantWarehouseIDOverride)), __LINE__);
        }
        $this->MerchantWarehouseIDOverride = $merchantWarehouseIDOverride;
        return $this;
    }
    /**
     * Get CreditCardToken value
     * @return string|null
     */
    public function getCreditCardToken()
    {
        return $this->CreditCardToken;
    }
    /**
     * Set CreditCardToken value
     * @param string $creditCardToken
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setCreditCardToken($creditCardToken = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardToken) && !is_string($creditCardToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditCardToken)), __LINE__);
        }
        $this->CreditCardToken = $creditCardToken;
        return $this;
    }
    /**
     * Get BillingName value
     * @return string|null
     */
    public function getBillingName()
    {
        return $this->BillingName;
    }
    /**
     * Set BillingName value
     * @param string $billingName
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setBillingName($billingName = null)
    {
        // validation for constraint: string
        if (!is_null($billingName) && !is_string($billingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingName)), __LINE__);
        }
        $this->BillingName = $billingName;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return string|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param string $billingAddress
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setBillingAddress($billingAddress = null)
    {
        // validation for constraint: string
        if (!is_null($billingAddress) && !is_string($billingAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingAddress)), __LINE__);
        }
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get BillingAddress2 value
     * @return string|null
     */
    public function getBillingAddress2()
    {
        return $this->BillingAddress2;
    }
    /**
     * Set BillingAddress2 value
     * @param string $billingAddress2
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setBillingAddress2($billingAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($billingAddress2) && !is_string($billingAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingAddress2)), __LINE__);
        }
        $this->BillingAddress2 = $billingAddress2;
        return $this;
    }
    /**
     * Get BillingCity value
     * @return string|null
     */
    public function getBillingCity()
    {
        return $this->BillingCity;
    }
    /**
     * Set BillingCity value
     * @param string $billingCity
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setBillingCity($billingCity = null)
    {
        // validation for constraint: string
        if (!is_null($billingCity) && !is_string($billingCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCity)), __LINE__);
        }
        $this->BillingCity = $billingCity;
        return $this;
    }
    /**
     * Get BillingState value
     * @return string|null
     */
    public function getBillingState()
    {
        return $this->BillingState;
    }
    /**
     * Set BillingState value
     * @param string $billingState
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setBillingState($billingState = null)
    {
        // validation for constraint: string
        if (!is_null($billingState) && !is_string($billingState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingState)), __LINE__);
        }
        $this->BillingState = $billingState;
        return $this;
    }
    /**
     * Get BillingZip value
     * @return string|null
     */
    public function getBillingZip()
    {
        return $this->BillingZip;
    }
    /**
     * Set BillingZip value
     * @param string $billingZip
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setBillingZip($billingZip = null)
    {
        // validation for constraint: string
        if (!is_null($billingZip) && !is_string($billingZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingZip)), __LINE__);
        }
        $this->BillingZip = $billingZip;
        return $this;
    }
    /**
     * Get BillingCountry value
     * @return string|null
     */
    public function getBillingCountry()
    {
        return $this->BillingCountry;
    }
    /**
     * Set BillingCountry value
     * @param string $billingCountry
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setBillingCountry($billingCountry = null)
    {
        // validation for constraint: string
        if (!is_null($billingCountry) && !is_string($billingCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCountry)), __LINE__);
        }
        $this->BillingCountry = $billingCountry;
        return $this;
    }
    /**
     * Get CvcCode value
     * @return string|null
     */
    public function getCvcCode()
    {
        return $this->CvcCode;
    }
    /**
     * Set CvcCode value
     * @param string $cvcCode
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setCvcCode($cvcCode = null)
    {
        // validation for constraint: string
        if (!is_null($cvcCode) && !is_string($cvcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cvcCode)), __LINE__);
        }
        $this->CvcCode = $cvcCode;
        return $this;
    }
    /**
     * Get IssueNumber value
     * @return string|null
     */
    public function getIssueNumber()
    {
        return $this->IssueNumber;
    }
    /**
     * Set IssueNumber value
     * @param string $issueNumber
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setIssueNumber($issueNumber = null)
    {
        // validation for constraint: string
        if (!is_null($issueNumber) && !is_string($issueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issueNumber)), __LINE__);
        }
        $this->IssueNumber = $issueNumber;
        return $this;
    }
    /**
     * Get ClientIPAddress value
     * @return string|null
     */
    public function getClientIPAddress()
    {
        return $this->ClientIPAddress;
    }
    /**
     * Set ClientIPAddress value
     * @param string $clientIPAddress
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setClientIPAddress($clientIPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($clientIPAddress) && !is_string($clientIPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientIPAddress)), __LINE__);
        }
        $this->ClientIPAddress = $clientIPAddress;
        return $this;
    }
    /**
     * Get OtherData1 value
     * @return string|null
     */
    public function getOtherData1()
    {
        return $this->OtherData1;
    }
    /**
     * Set OtherData1 value
     * @param string $otherData1
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setOtherData1($otherData1 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData1) && !is_string($otherData1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData1)), __LINE__);
        }
        $this->OtherData1 = $otherData1;
        return $this;
    }
    /**
     * Get OtherData2 value
     * @return string|null
     */
    public function getOtherData2()
    {
        return $this->OtherData2;
    }
    /**
     * Set OtherData2 value
     * @param string $otherData2
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setOtherData2($otherData2 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData2) && !is_string($otherData2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData2)), __LINE__);
        }
        $this->OtherData2 = $otherData2;
        return $this;
    }
    /**
     * Get OtherData3 value
     * @return string|null
     */
    public function getOtherData3()
    {
        return $this->OtherData3;
    }
    /**
     * Set OtherData3 value
     * @param string $otherData3
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setOtherData3($otherData3 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData3) && !is_string($otherData3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData3)), __LINE__);
        }
        $this->OtherData3 = $otherData3;
        return $this;
    }
    /**
     * Get OtherData4 value
     * @return string|null
     */
    public function getOtherData4()
    {
        return $this->OtherData4;
    }
    /**
     * Set OtherData4 value
     * @param string $otherData4
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setOtherData4($otherData4 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData4) && !is_string($otherData4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData4)), __LINE__);
        }
        $this->OtherData4 = $otherData4;
        return $this;
    }
    /**
     * Get OtherData5 value
     * @return string|null
     */
    public function getOtherData5()
    {
        return $this->OtherData5;
    }
    /**
     * Set OtherData5 value
     * @param string $otherData5
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setOtherData5($otherData5 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData5) && !is_string($otherData5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData5)), __LINE__);
        }
        $this->OtherData5 = $otherData5;
        return $this;
    }
    /**
     * Get OtherData6 value
     * @return string|null
     */
    public function getOtherData6()
    {
        return $this->OtherData6;
    }
    /**
     * Set OtherData6 value
     * @param string $otherData6
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setOtherData6($otherData6 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData6) && !is_string($otherData6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData6)), __LINE__);
        }
        $this->OtherData6 = $otherData6;
        return $this;
    }
    /**
     * Get OtherData7 value
     * @return string|null
     */
    public function getOtherData7()
    {
        return $this->OtherData7;
    }
    /**
     * Set OtherData7 value
     * @param string $otherData7
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setOtherData7($otherData7 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData7) && !is_string($otherData7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData7)), __LINE__);
        }
        $this->OtherData7 = $otherData7;
        return $this;
    }
    /**
     * Get OtherData8 value
     * @return string|null
     */
    public function getOtherData8()
    {
        return $this->OtherData8;
    }
    /**
     * Set OtherData8 value
     * @param string $otherData8
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setOtherData8($otherData8 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData8) && !is_string($otherData8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData8)), __LINE__);
        }
        $this->OtherData8 = $otherData8;
        return $this;
    }
    /**
     * Get OtherData9 value
     * @return string|null
     */
    public function getOtherData9()
    {
        return $this->OtherData9;
    }
    /**
     * Set OtherData9 value
     * @param string $otherData9
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setOtherData9($otherData9 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData9) && !is_string($otherData9)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData9)), __LINE__);
        }
        $this->OtherData9 = $otherData9;
        return $this;
    }
    /**
     * Get OtherData10 value
     * @return string|null
     */
    public function getOtherData10()
    {
        return $this->OtherData10;
    }
    /**
     * Set OtherData10 value
     * @param string $otherData10
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setOtherData10($otherData10 = null)
    {
        // validation for constraint: string
        if (!is_null($otherData10) && !is_string($otherData10)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otherData10)), __LINE__);
        }
        $this->OtherData10 = $otherData10;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChargeCreditCardTokenRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
