<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeCreditCardRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:ChargeCreditCardRequest
 * @subpackage Structs
 */
class ChargeCreditCardRequest extends BaseChargeCreditCardRequest
{
    /**
     * The ExpirationMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpirationMonth;
    /**
     * The ExpirationYear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpirationYear;
    /**
     * The CreditCardType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CreditCardType;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderID;
    /**
     * The MaxAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxAmount;
    /**
     * The CreditCardNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditCardNumber;
    /**
     * The BillingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingName;
    /**
     * The BillingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingAddress;
    /**
     * The BillingAddress2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingAddress2;
    /**
     * The BillingCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCity;
    /**
     * The BillingState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingState;
    /**
     * The BillingZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingZip;
    /**
     * The BillingCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCountry;
    /**
     * The CvcCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CvcCode;
    /**
     * The IssueNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueNumber;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * Constructor method for ChargeCreditCardRequest
     * @uses ChargeCreditCardRequest::setExpirationMonth()
     * @uses ChargeCreditCardRequest::setExpirationYear()
     * @uses ChargeCreditCardRequest::setCreditCardType()
     * @uses ChargeCreditCardRequest::setOrderID()
     * @uses ChargeCreditCardRequest::setMaxAmount()
     * @uses ChargeCreditCardRequest::setCreditCardNumber()
     * @uses ChargeCreditCardRequest::setBillingName()
     * @uses ChargeCreditCardRequest::setBillingAddress()
     * @uses ChargeCreditCardRequest::setBillingAddress2()
     * @uses ChargeCreditCardRequest::setBillingCity()
     * @uses ChargeCreditCardRequest::setBillingState()
     * @uses ChargeCreditCardRequest::setBillingZip()
     * @uses ChargeCreditCardRequest::setBillingCountry()
     * @uses ChargeCreditCardRequest::setCvcCode()
     * @uses ChargeCreditCardRequest::setIssueNumber()
     * @uses ChargeCreditCardRequest::setOrderKey()
     * @param int $expirationMonth
     * @param int $expirationYear
     * @param int $creditCardType
     * @param int $orderID
     * @param float $maxAmount
     * @param string $creditCardNumber
     * @param string $billingName
     * @param string $billingAddress
     * @param string $billingAddress2
     * @param string $billingCity
     * @param string $billingState
     * @param string $billingZip
     * @param string $billingCountry
     * @param string $cvcCode
     * @param string $issueNumber
     * @param string $orderKey
     */
    public function __construct($expirationMonth = null, $expirationYear = null, $creditCardType = null, $orderID = null, $maxAmount = null, $creditCardNumber = null, $billingName = null, $billingAddress = null, $billingAddress2 = null, $billingCity = null, $billingState = null, $billingZip = null, $billingCountry = null, $cvcCode = null, $issueNumber = null, $orderKey = null)
    {
        $this
            ->setExpirationMonth($expirationMonth)
            ->setExpirationYear($expirationYear)
            ->setCreditCardType($creditCardType)
            ->setOrderID($orderID)
            ->setMaxAmount($maxAmount)
            ->setCreditCardNumber($creditCardNumber)
            ->setBillingName($billingName)
            ->setBillingAddress($billingAddress)
            ->setBillingAddress2($billingAddress2)
            ->setBillingCity($billingCity)
            ->setBillingState($billingState)
            ->setBillingZip($billingZip)
            ->setBillingCountry($billingCountry)
            ->setCvcCode($cvcCode)
            ->setIssueNumber($issueNumber)
            ->setOrderKey($orderKey);
    }
    /**
     * Get ExpirationMonth value
     * @return int
     */
    public function getExpirationMonth()
    {
        return $this->ExpirationMonth;
    }
    /**
     * Set ExpirationMonth value
     * @param int $expirationMonth
     * @return \StructType\ChargeCreditCardRequest
     */
    public function setExpirationMonth($expirationMonth = null)
    {
        // validation for constraint: int
        if (!is_null($expirationMonth) && !is_numeric($expirationMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expirationMonth)), __LINE__);
        }
        $this->ExpirationMonth = $expirationMonth;
        return $this;
    }
    /**
     * Get ExpirationYear value
     * @return int
     */
    public function getExpirationYear()
    {
        return $this->ExpirationYear;
    }
    /**
     * Set ExpirationYear value
     * @param int $expirationYear
     * @return \StructType\ChargeCreditCardRequest
     */
    public function setExpirationYear($expirationYear = null)
    {
        // validation for constraint: int
        if (!is_null($expirationYear) && !is_numeric($expirationYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expirationYear)), __LINE__);
        }
        $this->ExpirationYear = $expirationYear;
        return $this;
    }
    /**
     * Get CreditCardType value
     * @return int
     */
    public function getCreditCardType()
    {
        return $this->CreditCardType;
    }
    /**
     * Set CreditCardType value
     * @param int $creditCardType
     * @return \StructType\ChargeCreditCardRequest
     */
    public function setCreditCardType($creditCardType = null)
    {
        // validation for constraint: int
        if (!is_null($creditCardType) && !is_numeric($creditCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($creditCardType)), __LINE__);
        }
        $this->CreditCardType = $creditCardType;
        return $this;
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\ChargeCreditCardRequest
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get MaxAmount value
     * @return float
     */
    public function getMaxAmount()
    {
        return $this->MaxAmount;
    }
    /**
     * Set MaxAmount value
     * @param float $maxAmount
     * @return \StructType\ChargeCreditCardRequest
     */
    public function setMaxAmount($maxAmount = null)
    {
        $this->MaxAmount = $maxAmount;
        return $this;
    }
    /**
     * Get CreditCardNumber value
     * @return string|null
     */
    public function getCreditCardNumber()
    {
        return $this->CreditCardNumber;
    }
    /**
     * Set CreditCardNumber value
     * @param string $creditCardNumber
     * @return \StructType\ChargeCreditCardRequest
     */
    public function setCreditCardNumber($creditCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardNumber) && !is_string($creditCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditCardNumber)), __LINE__);
        }
        $this->CreditCardNumber = $creditCardNumber;
        return $this;
    }
    /**
     * Get BillingName value
     * @return string|null
     */
    public function getBillingName()
    {
        return $this->BillingName;
    }
    /**
     * Set BillingName value
     * @param string $billingName
     * @return \StructType\ChargeCreditCardRequest
     */
    public function setBillingName($billingName = null)
    {
        // validation for constraint: string
        if (!is_null($billingName) && !is_string($billingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingName)), __LINE__);
        }
        $this->BillingName = $billingName;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return string|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param string $billingAddress
     * @return \StructType\ChargeCreditCardRequest
     */
    public function setBillingAddress($billingAddress = null)
    {
        // validation for constraint: string
        if (!is_null($billingAddress) && !is_string($billingAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingAddress)), __LINE__);
        }
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get BillingAddress2 value
     * @return string|null
     */
    public function getBillingAddress2()
    {
        return $this->BillingAddress2;
    }
    /**
     * Set BillingAddress2 value
     * @param string $billingAddress2
     * @return \StructType\ChargeCreditCardRequest
     */
    public function setBillingAddress2($billingAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($billingAddress2) && !is_string($billingAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingAddress2)), __LINE__);
        }
        $this->BillingAddress2 = $billingAddress2;
        return $this;
    }
    /**
     * Get BillingCity value
     * @return string|null
     */
    public function getBillingCity()
    {
        return $this->BillingCity;
    }
    /**
     * Set BillingCity value
     * @param string $billingCity
     * @return \StructType\ChargeCreditCardRequest
     */
    public function setBillingCity($billingCity = null)
    {
        // validation for constraint: string
        if (!is_null($billingCity) && !is_string($billingCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCity)), __LINE__);
        }
        $this->BillingCity = $billingCity;
        return $this;
    }
    /**
     * Get BillingState value
     * @return string|null
     */
    public function getBillingState()
    {
        return $this->BillingState;
    }
    /**
     * Set BillingState value
     * @param string $billingState
     * @return \StructType\ChargeCreditCardRequest
     */
    public function setBillingState($billingState = null)
    {
        // validation for constraint: string
        if (!is_null($billingState) && !is_string($billingState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingState)), __LINE__);
        }
        $this->BillingState = $billingState;
        return $this;
    }
    /**
     * Get BillingZip value
     * @return string|null
     */
    public function getBillingZip()
    {
        return $this->BillingZip;
    }
    /**
     * Set BillingZip value
     * @param string $billingZip
     * @return \StructType\ChargeCreditCardRequest
     */
    public function setBillingZip($billingZip = null)
    {
        // validation for constraint: string
        if (!is_null($billingZip) && !is_string($billingZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingZip)), __LINE__);
        }
        $this->BillingZip = $billingZip;
        return $this;
    }
    /**
     * Get BillingCountry value
     * @return string|null
     */
    public function getBillingCountry()
    {
        return $this->BillingCountry;
    }
    /**
     * Set BillingCountry value
     * @param string $billingCountry
     * @return \StructType\ChargeCreditCardRequest
     */
    public function setBillingCountry($billingCountry = null)
    {
        // validation for constraint: string
        if (!is_null($billingCountry) && !is_string($billingCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCountry)), __LINE__);
        }
        $this->BillingCountry = $billingCountry;
        return $this;
    }
    /**
     * Get CvcCode value
     * @return string|null
     */
    public function getCvcCode()
    {
        return $this->CvcCode;
    }
    /**
     * Set CvcCode value
     * @param string $cvcCode
     * @return \StructType\ChargeCreditCardRequest
     */
    public function setCvcCode($cvcCode = null)
    {
        // validation for constraint: string
        if (!is_null($cvcCode) && !is_string($cvcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cvcCode)), __LINE__);
        }
        $this->CvcCode = $cvcCode;
        return $this;
    }
    /**
     * Get IssueNumber value
     * @return string|null
     */
    public function getIssueNumber()
    {
        return $this->IssueNumber;
    }
    /**
     * Set IssueNumber value
     * @param string $issueNumber
     * @return \StructType\ChargeCreditCardRequest
     */
    public function setIssueNumber($issueNumber = null)
    {
        // validation for constraint: string
        if (!is_null($issueNumber) && !is_string($issueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issueNumber)), __LINE__);
        }
        $this->IssueNumber = $issueNumber;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\ChargeCreditCardRequest
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChargeCreditCardRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
