<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeCreditCardOnFileRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:ChargeCreditCardOnFileRequest
 * @subpackage Structs
 */
class ChargeCreditCardOnFileRequest extends BaseChargeCreditCardRequest
{
    /**
     * The CreditCardAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreditCardAccountType;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrderID;
    /**
     * The MaxAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxAmount;
    /**
     * The OrderKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderKey;
    /**
     * Constructor method for ChargeCreditCardOnFileRequest
     * @uses ChargeCreditCardOnFileRequest::setCreditCardAccountType()
     * @uses ChargeCreditCardOnFileRequest::setOrderID()
     * @uses ChargeCreditCardOnFileRequest::setMaxAmount()
     * @uses ChargeCreditCardOnFileRequest::setOrderKey()
     * @param string $creditCardAccountType
     * @param int $orderID
     * @param float $maxAmount
     * @param string $orderKey
     */
    public function __construct($creditCardAccountType = null, $orderID = null, $maxAmount = null, $orderKey = null)
    {
        $this
            ->setCreditCardAccountType($creditCardAccountType)
            ->setOrderID($orderID)
            ->setMaxAmount($maxAmount)
            ->setOrderKey($orderKey);
    }
    /**
     * Get CreditCardAccountType value
     * @return string
     */
    public function getCreditCardAccountType()
    {
        return $this->CreditCardAccountType;
    }
    /**
     * Set CreditCardAccountType value
     * @uses \EnumType\AccountCreditCardType::valueIsValid()
     * @uses \EnumType\AccountCreditCardType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $creditCardAccountType
     * @return \StructType\ChargeCreditCardOnFileRequest
     */
    public function setCreditCardAccountType($creditCardAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountCreditCardType::valueIsValid($creditCardAccountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $creditCardAccountType, implode(', ', \EnumType\AccountCreditCardType::getValidValues())), __LINE__);
        }
        $this->CreditCardAccountType = $creditCardAccountType;
        return $this;
    }
    /**
     * Get OrderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param int $orderID
     * @return \StructType\ChargeCreditCardOnFileRequest
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !is_numeric($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get MaxAmount value
     * @return float
     */
    public function getMaxAmount()
    {
        return $this->MaxAmount;
    }
    /**
     * Set MaxAmount value
     * @param float $maxAmount
     * @return \StructType\ChargeCreditCardOnFileRequest
     */
    public function setMaxAmount($maxAmount = null)
    {
        $this->MaxAmount = $maxAmount;
        return $this;
    }
    /**
     * Get OrderKey value
     * @return string|null
     */
    public function getOrderKey()
    {
        return $this->OrderKey;
    }
    /**
     * Set OrderKey value
     * @param string $orderKey
     * @return \StructType\ChargeCreditCardOnFileRequest
     */
    public function setOrderKey($orderKey = null)
    {
        // validation for constraint: string
        if (!is_null($orderKey) && !is_string($orderKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderKey)), __LINE__);
        }
        $this->OrderKey = $orderKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChargeCreditCardOnFileRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
