<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeOrderStatusBatchRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:ChangeOrderStatusBatchRequest
 * @subpackage Structs
 */
class ChangeOrderStatusBatchRequest extends ApiRequest
{
    /**
     * The OrderStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderStatus;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOrderBatchDetailRequest
     */
    public $Details;
    /**
     * Constructor method for ChangeOrderStatusBatchRequest
     * @uses ChangeOrderStatusBatchRequest::setOrderStatus()
     * @uses ChangeOrderStatusBatchRequest::setDetails()
     * @param string $orderStatus
     * @param \ArrayType\ArrayOfOrderBatchDetailRequest $details
     */
    public function __construct($orderStatus = null, \ArrayType\ArrayOfOrderBatchDetailRequest $details = null)
    {
        $this
            ->setOrderStatus($orderStatus)
            ->setDetails($details);
    }
    /**
     * Get OrderStatus value
     * @return string
     */
    public function getOrderStatus()
    {
        return $this->OrderStatus;
    }
    /**
     * Set OrderStatus value
     * @uses \EnumType\OrderStatusType::valueIsValid()
     * @uses \EnumType\OrderStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderStatus
     * @return \StructType\ChangeOrderStatusBatchRequest
     */
    public function setOrderStatus($orderStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderStatusType::valueIsValid($orderStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $orderStatus, implode(', ', \EnumType\OrderStatusType::getValidValues())), __LINE__);
        }
        $this->OrderStatus = $orderStatus;
        return $this;
    }
    /**
     * Get Details value
     * @return \ArrayType\ArrayOfOrderBatchDetailRequest|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \ArrayType\ArrayOfOrderBatchDetailRequest $details
     * @return \StructType\ChangeOrderStatusBatchRequest
     */
    public function setDetails(\ArrayType\ArrayOfOrderBatchDetailRequest $details = null)
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChangeOrderStatusBatchRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
