<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseCreatePayoutRequest StructType
 * @subpackage Structs
 */
class BaseCreatePayoutRequest extends ApiRequest
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The BankAccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BankAccountID;
    /**
     * The PaymentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PaymentDate;
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The TransactionNote
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionNote;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for BaseCreatePayoutRequest
     * @uses BaseCreatePayoutRequest::setCustomerID()
     * @uses BaseCreatePayoutRequest::setBankAccountID()
     * @uses BaseCreatePayoutRequest::setPaymentDate()
     * @uses BaseCreatePayoutRequest::setReference()
     * @uses BaseCreatePayoutRequest::setTransactionNote()
     * @uses BaseCreatePayoutRequest::setCustomerKey()
     * @param int $customerID
     * @param int $bankAccountID
     * @param string $paymentDate
     * @param string $reference
     * @param string $transactionNote
     * @param string $customerKey
     */
    public function __construct($customerID = null, $bankAccountID = null, $paymentDate = null, $reference = null, $transactionNote = null, $customerKey = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setBankAccountID($bankAccountID)
            ->setPaymentDate($paymentDate)
            ->setReference($reference)
            ->setTransactionNote($transactionNote)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\BaseCreatePayoutRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get BankAccountID value
     * @return int
     */
    public function getBankAccountID()
    {
        return $this->BankAccountID;
    }
    /**
     * Set BankAccountID value
     * @param int $bankAccountID
     * @return \StructType\BaseCreatePayoutRequest
     */
    public function setBankAccountID($bankAccountID = null)
    {
        // validation for constraint: int
        if (!is_null($bankAccountID) && !is_numeric($bankAccountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bankAccountID)), __LINE__);
        }
        $this->BankAccountID = $bankAccountID;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \StructType\BaseCreatePayoutRequest
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\BaseCreatePayoutRequest
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get TransactionNote value
     * @return string|null
     */
    public function getTransactionNote()
    {
        return $this->TransactionNote;
    }
    /**
     * Set TransactionNote value
     * @param string $transactionNote
     * @return \StructType\BaseCreatePayoutRequest
     */
    public function setTransactionNote($transactionNote = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNote) && !is_string($transactionNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionNote)), __LINE__);
        }
        $this->TransactionNote = $transactionNote;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\BaseCreatePayoutRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseCreatePayoutRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
