<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorizeOnlyCreditCardTokenRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:AuthorizeOnlyCreditCardTokenRequest
 * @subpackage Structs
 */
class AuthorizeOnlyCreditCardTokenRequest extends BaseAuthorizeOnlyCreditCardTokenRequest
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WarehouseID;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The CreditCardToken
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditCardToken;
    /**
     * The BillingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingName;
    /**
     * The BillingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingAddress;
    /**
     * The BillingCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCity;
    /**
     * The BillingState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingState;
    /**
     * The BillingZip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingZip;
    /**
     * The BillingCountry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCountry;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The CvcCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CvcCode;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for AuthorizeOnlyCreditCardTokenRequest
     * @uses AuthorizeOnlyCreditCardTokenRequest::setAmount()
     * @uses AuthorizeOnlyCreditCardTokenRequest::setWarehouseID()
     * @uses AuthorizeOnlyCreditCardTokenRequest::setCustomerID()
     * @uses AuthorizeOnlyCreditCardTokenRequest::setCreditCardToken()
     * @uses AuthorizeOnlyCreditCardTokenRequest::setBillingName()
     * @uses AuthorizeOnlyCreditCardTokenRequest::setBillingAddress()
     * @uses AuthorizeOnlyCreditCardTokenRequest::setBillingCity()
     * @uses AuthorizeOnlyCreditCardTokenRequest::setBillingState()
     * @uses AuthorizeOnlyCreditCardTokenRequest::setBillingZip()
     * @uses AuthorizeOnlyCreditCardTokenRequest::setBillingCountry()
     * @uses AuthorizeOnlyCreditCardTokenRequest::setCurrencyCode()
     * @uses AuthorizeOnlyCreditCardTokenRequest::setCvcCode()
     * @uses AuthorizeOnlyCreditCardTokenRequest::setCustomerKey()
     * @param float $amount
     * @param int $warehouseID
     * @param int $customerID
     * @param string $creditCardToken
     * @param string $billingName
     * @param string $billingAddress
     * @param string $billingCity
     * @param string $billingState
     * @param string $billingZip
     * @param string $billingCountry
     * @param string $currencyCode
     * @param string $cvcCode
     * @param string $customerKey
     */
    public function __construct($amount = null, $warehouseID = null, $customerID = null, $creditCardToken = null, $billingName = null, $billingAddress = null, $billingCity = null, $billingState = null, $billingZip = null, $billingCountry = null, $currencyCode = null, $cvcCode = null, $customerKey = null)
    {
        $this
            ->setAmount($amount)
            ->setWarehouseID($warehouseID)
            ->setCustomerID($customerID)
            ->setCreditCardToken($creditCardToken)
            ->setBillingName($billingName)
            ->setBillingAddress($billingAddress)
            ->setBillingCity($billingCity)
            ->setBillingState($billingState)
            ->setBillingZip($billingZip)
            ->setBillingCountry($billingCountry)
            ->setCurrencyCode($currencyCode)
            ->setCvcCode($cvcCode)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\AuthorizeOnlyCreditCardTokenRequest
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get WarehouseID value
     * @return int
     */
    public function getWarehouseID()
    {
        return $this->WarehouseID;
    }
    /**
     * Set WarehouseID value
     * @param int $warehouseID
     * @return \StructType\AuthorizeOnlyCreditCardTokenRequest
     */
    public function setWarehouseID($warehouseID = null)
    {
        // validation for constraint: int
        if (!is_null($warehouseID) && !is_numeric($warehouseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($warehouseID)), __LINE__);
        }
        $this->WarehouseID = $warehouseID;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\AuthorizeOnlyCreditCardTokenRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CreditCardToken value
     * @return string|null
     */
    public function getCreditCardToken()
    {
        return $this->CreditCardToken;
    }
    /**
     * Set CreditCardToken value
     * @param string $creditCardToken
     * @return \StructType\AuthorizeOnlyCreditCardTokenRequest
     */
    public function setCreditCardToken($creditCardToken = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardToken) && !is_string($creditCardToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditCardToken)), __LINE__);
        }
        $this->CreditCardToken = $creditCardToken;
        return $this;
    }
    /**
     * Get BillingName value
     * @return string|null
     */
    public function getBillingName()
    {
        return $this->BillingName;
    }
    /**
     * Set BillingName value
     * @param string $billingName
     * @return \StructType\AuthorizeOnlyCreditCardTokenRequest
     */
    public function setBillingName($billingName = null)
    {
        // validation for constraint: string
        if (!is_null($billingName) && !is_string($billingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingName)), __LINE__);
        }
        $this->BillingName = $billingName;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return string|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param string $billingAddress
     * @return \StructType\AuthorizeOnlyCreditCardTokenRequest
     */
    public function setBillingAddress($billingAddress = null)
    {
        // validation for constraint: string
        if (!is_null($billingAddress) && !is_string($billingAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingAddress)), __LINE__);
        }
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get BillingCity value
     * @return string|null
     */
    public function getBillingCity()
    {
        return $this->BillingCity;
    }
    /**
     * Set BillingCity value
     * @param string $billingCity
     * @return \StructType\AuthorizeOnlyCreditCardTokenRequest
     */
    public function setBillingCity($billingCity = null)
    {
        // validation for constraint: string
        if (!is_null($billingCity) && !is_string($billingCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCity)), __LINE__);
        }
        $this->BillingCity = $billingCity;
        return $this;
    }
    /**
     * Get BillingState value
     * @return string|null
     */
    public function getBillingState()
    {
        return $this->BillingState;
    }
    /**
     * Set BillingState value
     * @param string $billingState
     * @return \StructType\AuthorizeOnlyCreditCardTokenRequest
     */
    public function setBillingState($billingState = null)
    {
        // validation for constraint: string
        if (!is_null($billingState) && !is_string($billingState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingState)), __LINE__);
        }
        $this->BillingState = $billingState;
        return $this;
    }
    /**
     * Get BillingZip value
     * @return string|null
     */
    public function getBillingZip()
    {
        return $this->BillingZip;
    }
    /**
     * Set BillingZip value
     * @param string $billingZip
     * @return \StructType\AuthorizeOnlyCreditCardTokenRequest
     */
    public function setBillingZip($billingZip = null)
    {
        // validation for constraint: string
        if (!is_null($billingZip) && !is_string($billingZip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingZip)), __LINE__);
        }
        $this->BillingZip = $billingZip;
        return $this;
    }
    /**
     * Get BillingCountry value
     * @return string|null
     */
    public function getBillingCountry()
    {
        return $this->BillingCountry;
    }
    /**
     * Set BillingCountry value
     * @param string $billingCountry
     * @return \StructType\AuthorizeOnlyCreditCardTokenRequest
     */
    public function setBillingCountry($billingCountry = null)
    {
        // validation for constraint: string
        if (!is_null($billingCountry) && !is_string($billingCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCountry)), __LINE__);
        }
        $this->BillingCountry = $billingCountry;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\AuthorizeOnlyCreditCardTokenRequest
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get CvcCode value
     * @return string|null
     */
    public function getCvcCode()
    {
        return $this->CvcCode;
    }
    /**
     * Set CvcCode value
     * @param string $cvcCode
     * @return \StructType\AuthorizeOnlyCreditCardTokenRequest
     */
    public function setCvcCode($cvcCode = null)
    {
        // validation for constraint: string
        if (!is_null($cvcCode) && !is_string($cvcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cvcCode)), __LINE__);
        }
        $this->CvcCode = $cvcCode;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\AuthorizeOnlyCreditCardTokenRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthorizeOnlyCreditCardTokenRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
