<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorizeOnlyCreditCardTokenOnFileRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:AuthorizeOnlyCreditCardTokenOnFileRequest
 * @subpackage Structs
 */
class AuthorizeOnlyCreditCardTokenOnFileRequest extends BaseAuthorizeOnlyCreditCardTokenRequest
{
    /**
     * The CreditCardAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreditCardAccountType;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WarehouseID;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The CustomerKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerKey;
    /**
     * Constructor method for AuthorizeOnlyCreditCardTokenOnFileRequest
     * @uses AuthorizeOnlyCreditCardTokenOnFileRequest::setCreditCardAccountType()
     * @uses AuthorizeOnlyCreditCardTokenOnFileRequest::setWarehouseID()
     * @uses AuthorizeOnlyCreditCardTokenOnFileRequest::setCustomerID()
     * @uses AuthorizeOnlyCreditCardTokenOnFileRequest::setAmount()
     * @uses AuthorizeOnlyCreditCardTokenOnFileRequest::setCurrencyCode()
     * @uses AuthorizeOnlyCreditCardTokenOnFileRequest::setCustomerKey()
     * @param string $creditCardAccountType
     * @param int $warehouseID
     * @param int $customerID
     * @param float $amount
     * @param string $currencyCode
     * @param string $customerKey
     */
    public function __construct($creditCardAccountType = null, $warehouseID = null, $customerID = null, $amount = null, $currencyCode = null, $customerKey = null)
    {
        $this
            ->setCreditCardAccountType($creditCardAccountType)
            ->setWarehouseID($warehouseID)
            ->setCustomerID($customerID)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setCustomerKey($customerKey);
    }
    /**
     * Get CreditCardAccountType value
     * @return string
     */
    public function getCreditCardAccountType()
    {
        return $this->CreditCardAccountType;
    }
    /**
     * Set CreditCardAccountType value
     * @uses \EnumType\AccountCreditCardType::valueIsValid()
     * @uses \EnumType\AccountCreditCardType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $creditCardAccountType
     * @return \StructType\AuthorizeOnlyCreditCardTokenOnFileRequest
     */
    public function setCreditCardAccountType($creditCardAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountCreditCardType::valueIsValid($creditCardAccountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $creditCardAccountType, implode(', ', \EnumType\AccountCreditCardType::getValidValues())), __LINE__);
        }
        $this->CreditCardAccountType = $creditCardAccountType;
        return $this;
    }
    /**
     * Get WarehouseID value
     * @return int
     */
    public function getWarehouseID()
    {
        return $this->WarehouseID;
    }
    /**
     * Set WarehouseID value
     * @param int $warehouseID
     * @return \StructType\AuthorizeOnlyCreditCardTokenOnFileRequest
     */
    public function setWarehouseID($warehouseID = null)
    {
        // validation for constraint: int
        if (!is_null($warehouseID) && !is_numeric($warehouseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($warehouseID)), __LINE__);
        }
        $this->WarehouseID = $warehouseID;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\AuthorizeOnlyCreditCardTokenOnFileRequest
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\AuthorizeOnlyCreditCardTokenOnFileRequest
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\AuthorizeOnlyCreditCardTokenOnFileRequest
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\AuthorizeOnlyCreditCardTokenOnFileRequest
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthorizeOnlyCreditCardTokenOnFileRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
