<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorizeOnlyCreditCardResponse StructType
 * @subpackage Structs
 */
class AuthorizeOnlyCreditCardResponse extends ApiResponse
{
    /**
     * The AuthorizationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthorizationCode;
    /**
     * The MerchantTransactionKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantTransactionKey;
    /**
     * Constructor method for AuthorizeOnlyCreditCardResponse
     * @uses AuthorizeOnlyCreditCardResponse::setAuthorizationCode()
     * @uses AuthorizeOnlyCreditCardResponse::setMerchantTransactionKey()
     * @param string $authorizationCode
     * @param string $merchantTransactionKey
     */
    public function __construct($authorizationCode = null, $merchantTransactionKey = null)
    {
        $this
            ->setAuthorizationCode($authorizationCode)
            ->setMerchantTransactionKey($merchantTransactionKey);
    }
    /**
     * Get AuthorizationCode value
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return $this->AuthorizationCode;
    }
    /**
     * Set AuthorizationCode value
     * @param string $authorizationCode
     * @return \StructType\AuthorizeOnlyCreditCardResponse
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorizationCode)), __LINE__);
        }
        $this->AuthorizationCode = $authorizationCode;
        return $this;
    }
    /**
     * Get MerchantTransactionKey value
     * @return string|null
     */
    public function getMerchantTransactionKey()
    {
        return $this->MerchantTransactionKey;
    }
    /**
     * Set MerchantTransactionKey value
     * @param string $merchantTransactionKey
     * @return \StructType\AuthorizeOnlyCreditCardResponse
     */
    public function setMerchantTransactionKey($merchantTransactionKey = null)
    {
        // validation for constraint: string
        if (!is_null($merchantTransactionKey) && !is_string($merchantTransactionKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($merchantTransactionKey)), __LINE__);
        }
        $this->MerchantTransactionKey = $merchantTransactionKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthorizeOnlyCreditCardResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
