<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remove ServiceType
 * @subpackage Services
 */
class Remove extends AbstractSoapClientBase
{
    /**
     * Sets the ApiAuthentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApiAuthentication $apiAuthentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApiAuthentication(\StructType\ApiAuthentication $apiAuthentication, $nameSpace = 'http://api.exigo.com/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApiAuthentication', $apiAuthentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named RemoveApiWhitelist
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Remove an existing Whitelisted IP range
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveApiWhitelistRequest $removeApiWhitelistRequest
     * @return \StructType\RemoveApiWhitelistResponse|bool
     */
    public function RemoveApiWhitelist(\StructType\RemoveApiWhitelistRequest $removeApiWhitelistRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->RemoveApiWhitelist($removeApiWhitelistRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RemovePartyGuests
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Removes one or more guests from a party.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemovePartyGuestsRequest $removePartyGuestsRequest
     * @return \StructType\RemovePartyGuestsResponse|bool
     */
    public function RemovePartyGuests(\StructType\RemovePartyGuestsRequest $removePartyGuestsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->RemovePartyGuests($removePartyGuestsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RemoveApiWhitelistResponse|\StructType\RemovePartyGuestsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
