<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Refund ServiceType
 * @subpackage Services
 */
class Refund extends AbstractSoapClientBase
{
    /**
     * Sets the ApiAuthentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApiAuthentication $apiAuthentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApiAuthentication(\StructType\ApiAuthentication $apiAuthentication, $nameSpace = 'http://api.exigo.com/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApiAuthentication', $apiAuthentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named RefundPriorCreditCardCharge
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Refunds a prior charge. To be used with an order.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RefundPriorCreditCardChargeRequest $refundPriorCreditCardChargeRequest
     * @return \StructType\RefundPriorCreditCardChargeResponse|bool
     */
    public function RefundPriorCreditCardCharge(\StructType\RefundPriorCreditCardChargeRequest $refundPriorCreditCardChargeRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->RefundPriorCreditCardCharge($refundPriorCreditCardChargeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RefundPriorWalletCharge
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Refunds a prior wallet charge. To be used with an order.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RefundPriorWalletChargeRequest $refundPriorWalletChargeRequest
     * @return \StructType\RefundPriorWalletChargeResponse|bool
     */
    public function RefundPriorWalletCharge(\StructType\RefundPriorWalletChargeRequest $refundPriorWalletChargeRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->RefundPriorWalletCharge($refundPriorWalletChargeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RefundPriorCreditCardChargeResponse|\StructType\RefundPriorWalletChargeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
