<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process ServiceType
 * @subpackage Services
 */
class Process extends AbstractSoapClientBase
{
    /**
     * Sets the ApiAuthentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApiAuthentication $apiAuthentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApiAuthentication(\StructType\ApiAuthentication $apiAuthentication, $nameSpace = 'http://api.exigo.com/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApiAuthentication', $apiAuthentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ProcessTransaction
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Commits multiple requests in one step. All business rules are checked before commit and it is a commit-all or fail-all.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransactionalRequest $transactionalRequest
     * @return \StructType\TransactionalResponse|bool
     */
    public function ProcessTransaction(\StructType\TransactionalRequest $transactionalRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->ProcessTransaction($transactionalRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TransactionalResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
