<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Place ServiceType
 * @subpackage Services
 */
class Place extends AbstractSoapClientBase
{
    /**
     * Sets the ApiAuthentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApiAuthentication $apiAuthentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApiAuthentication(\StructType\ApiAuthentication $apiAuthentication, $nameSpace = 'http://api.exigo.com/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApiAuthentication', $apiAuthentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named PlaceBinaryNode
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Inserts/Moves a customer within the Binary Tree.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PlaceBinaryNodeRequest $placeBinaryNodeRequest
     * @return \StructType\PlaceBinaryNodeResponse|bool
     */
    public function PlaceBinaryNode(\StructType\PlaceBinaryNodeRequest $placeBinaryNodeRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->PlaceBinaryNode($placeBinaryNodeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PlaceEnrollerNode
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Inserts/Moves a customer within the Enroller Tree.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PlaceEnrollerNodeRequest $placeEnrollerNodeRequest
     * @return \StructType\PlaceEnrollerNodeResponse|bool
     */
    public function PlaceEnrollerNode(\StructType\PlaceEnrollerNodeRequest $placeEnrollerNodeRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->PlaceEnrollerNode($placeEnrollerNodeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PlaceMatrixNode
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Inserts/Moves a customer within the Matrix Tree.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PlaceMatrixNodeRequest $placeMatrixNodeRequest
     * @return \StructType\PlaceMatrixNodeResponse|bool
     */
    public function PlaceMatrixNode(\StructType\PlaceMatrixNodeRequest $placeMatrixNodeRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->PlaceMatrixNode($placeMatrixNodeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PlaceStackNode
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Inserts/Moves a customer within the Stack Tree.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PlaceStackNodeRequest $placeStackNodeRequest
     * @return \StructType\PlaceStackNodeResponse|bool
     */
    public function PlaceStackNode(\StructType\PlaceStackNodeRequest $placeStackNodeRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->PlaceStackNode($placeStackNodeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PlaceUniLevelNode
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Inserts/Moves a customer within the UniLevel (Sponsor) Tree.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PlaceUniLevelNodeRequest $placeUniLevelNodeRequest
     * @return \StructType\PlaceUniLevelNodeResponse|bool
     */
    public function PlaceUniLevelNode(\StructType\PlaceUniLevelNodeRequest $placeUniLevelNodeRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->PlaceUniLevelNode($placeUniLevelNodeRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PlaceBinaryNodeResponse|\StructType\PlaceEnrollerNodeResponse|\StructType\PlaceMatrixNodeResponse|\StructType\PlaceStackNodeResponse|\StructType\PlaceUniLevelNodeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
