<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the ApiAuthentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApiAuthentication $apiAuthentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApiAuthentication(\StructType\ApiAuthentication $apiAuthentication, $nameSpace = 'http://api.exigo.com/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApiAuthentication', $apiAuthentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetVolumes
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns volume records for a current period in a periodtype.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVolumesRequest $getVolumesRequest
     * @return \StructType\GetVolumesResponse|bool
     */
    public function GetVolumes(\StructType\GetVolumesRequest $getVolumesRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVolumes($getVolumesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWarehouses
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Gets a list of warehouses setup in the system.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWarehousesRequest $getWarehousesRequest
     * @return \StructType\GetWarehousesResponse|bool
     */
    public function GetWarehouses(\StructType\GetWarehousesRequest $getWarehousesRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetWarehouses($getWarehousesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderInvoice
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns an Rendered Order Invoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderInvoiceRequest $getOrderInvoiceRequest
     * @return \StructType\GetOrderInvoiceResponse|bool
     */
    public function GetOrderInvoice(\StructType\GetOrderInvoiceRequest $getOrderInvoiceRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOrderInvoice($getOrderInvoiceRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountDirectDeposit
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns direct deposit info for an existing customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountDirectDepositRequest $getAccountDirectDepositRequest
     * @return \StructType\GetAccountDirectDepositResponse|bool
     */
    public function GetAccountDirectDeposit(\StructType\GetAccountDirectDepositRequest $getAccountDirectDepositRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountDirectDeposit($getAccountDirectDepositRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetApiWhitelist
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Get List of Whitelisted IP ranges
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetApiWhitelistRequest $getApiWhitelistRequest
     * @return \StructType\GetApiWhitelistResponse|bool
     */
    public function GetApiWhitelist(\StructType\GetApiWhitelistRequest $getApiWhitelistRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetApiWhitelist($getApiWhitelistRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAutoOrders
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns any AutoOrders setup and active for a given customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAutoOrdersRequest $getAutoOrdersRequest
     * @return \StructType\GetAutoOrdersResponse|bool
     */
    public function GetAutoOrders(\StructType\GetAutoOrdersRequest $getAutoOrdersRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAutoOrders($getAutoOrdersRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBinaryPreference
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns the currently configured placement preference for new placements under a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBinaryPreferenceRequest $getBinaryPreferenceRequest
     * @return \StructType\GetBinaryPreferenceResponse|bool
     */
    public function GetBinaryPreference(\StructType\GetBinaryPreferenceRequest $getBinaryPreferenceRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBinaryPreference($getBinaryPreferenceRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCompanyLanguages
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Gets languages list available to the company.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLanguagesRequest $getLanguagesRequest
     * @return \StructType\GetLanguagesResponse|bool
     */
    public function GetCompanyLanguages(\StructType\GetLanguagesRequest $getLanguagesRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCompanyLanguages($getLanguagesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCompanyNews
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Gets a list of company news descriptions.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompanyNewsRequest $getCompanyNewsRequest
     * @return \StructType\GetCompanyNewsResponse|bool
     */
    public function GetCompanyNews(\StructType\GetCompanyNewsRequest $getCompanyNewsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCompanyNews($getCompanyNewsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCompanyNewsItem
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Gets company news details.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompanyNewsItemRequest $getCompanyNewsItemRequest
     * @return \StructType\GetCompanyNewsItemResponse|bool
     */
    public function GetCompanyNewsItem(\StructType\GetCompanyNewsItemRequest $getCompanyNewsItemRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCompanyNewsItem($getCompanyNewsItemRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCountryRegions
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns countries setup for company as well as the regions for a single country requested.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCountryRegionsRequest $getCountryRegionsRequest
     * @return \StructType\GetCountryRegionsResponse|bool
     */
    public function GetCountryRegions(\StructType\GetCountryRegionsRequest $getCountryRegionsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCountryRegions($getCountryRegionsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerBalances
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns the sum of orders, payments, and adjustments per currency.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerBalancesRequest $getCustomerBalancesRequest
     * @return \StructType\GetCustomerBalancesResponse|bool
     */
    public function GetCustomerBalances(\StructType\GetCustomerBalancesRequest $getCustomerBalancesRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerBalances($getCustomerBalancesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerBilling
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Retruns billing accounts on file for a customer. Only => s last four digits of a credit card.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerBillingRequest $getCustomerBillingRequest
     * @return \StructType\GetCustomerBillingResponse|bool
     */
    public function GetCustomerBilling(\StructType\GetCustomerBillingRequest $getCustomerBillingRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerBilling($getCustomerBillingRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerExtended
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns extended properties setup for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerExtendedRequest $getCustomerExtendedRequest
     * @return \StructType\GetCustomerExtendedResponse|bool
     */
    public function GetCustomerExtended(\StructType\GetCustomerExtendedRequest $getCustomerExtendedRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerExtended($getCustomerExtendedRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerLeads
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Gets a list of customer leads.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerLeadsRequest $getCustomerLeadsRequest
     * @return \StructType\GetCustomerLeadsResponse|bool
     */
    public function GetCustomerLeads(\StructType\GetCustomerLeadsRequest $getCustomerLeadsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerLeads($getCustomerLeadsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerLeadSocialNetworks
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns a list of social network(s) for the customer lead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerLeadSocialNetworksRequest $getCustomerLeadSocialNetworksRequest
     * @return \StructType\GetCustomerLeadSocialNetworksResponse|bool
     */
    public function GetCustomerLeadSocialNetworks(\StructType\GetCustomerLeadSocialNetworksRequest $getCustomerLeadSocialNetworksRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerLeadSocialNetworks($getCustomerLeadSocialNetworksRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerNotes
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns the notes field for one or more customers that match the filter critera passed in.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerNotesRequest $getCustomerNotesRequest
     * @return \StructType\GetCustomerNotesResponse|bool
     */
    public function GetCustomerNotes(\StructType\GetCustomerNotesRequest $getCustomerNotesRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerNotes($getCustomerNotesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomers
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns one or more customers that match the filter critera passed in.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomersRequest $getCustomersRequest
     * @return \StructType\GetCustomersResponse|bool
     */
    public function GetCustomers(\StructType\GetCustomersRequest $getCustomersRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomers($getCustomersRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerSite
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns the public web site info setup for a customer. Pass in CustomerID or WebAlias.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerSiteRequest $getCustomerSiteRequest
     * @return \StructType\GetCustomerSiteResponse|bool
     */
    public function GetCustomerSite(\StructType\GetCustomerSiteRequest $getCustomerSiteRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerSite($getCustomerSiteRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerSocialNetworks
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns a list of social network(s) for the customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerSocialNetworksRequest $getCustomerSocialNetworksRequest
     * @return \StructType\GetCustomerSocialNetworksResponse|bool
     */
    public function GetCustomerSocialNetworks(\StructType\GetCustomerSocialNetworksRequest $getCustomerSocialNetworksRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerSocialNetworks($getCustomerSocialNetworksRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerWall
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Get wall item(s) from CustomerWall table.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerWallRequest $getCustomerWallRequest
     * @return \StructType\GetCustomerWallResponse|bool
     */
    public function GetCustomerWall(\StructType\GetCustomerWallRequest $getCustomerWallRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerWall($getCustomerWallRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomReport
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns a custom report in dataset format.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomReportRequest $getCustomReportRequest
     * @return \StructType\GetCustomReportResponse|bool
     */
    public function GetCustomReport(\StructType\GetCustomReportRequest $getCustomReportRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomReport($getCustomReportRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDownline
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Gets nodes in a downline.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDownlineRequest $getDownlineRequest
     * @return \StructType\GetDownlineResponse|bool
     */
    public function GetDownline(\StructType\GetDownlineRequest $getDownlineRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDownline($getDownlineRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEmailAttachment
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Gets an email attachment.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEmailAttachmentRequest $getEmailAttachmentRequest
     * @return \StructType\GetEmailAttachmentResponse|bool
     */
    public function GetEmailAttachment(\StructType\GetEmailAttachmentRequest $getEmailAttachmentRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEmailAttachment($getEmailAttachmentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetExtendedDbEntity
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Get Extended DB Entity.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEntityRequest $getEntityRequest
     * @return \StructType\GetEntityResponse|bool
     */
    public function GetExtendedDbEntity(\StructType\GetEntityRequest $getEntityRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetExtendedDbEntity($getEntityRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetExtendedDbSchema
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Get Extended DB schema.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSchemaRequest $getSchemaRequest
     * @return \StructType\GetSchemaResponse|bool
     */
    public function GetExtendedDbSchema(\StructType\GetSchemaRequest $getSchemaRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetExtendedDbSchema($getSchemaRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFileContents
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns a customer file for the given criteria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFileContentsRequest $getFileContentsRequest
     * @return \StructType\GetFileContentsResponse|bool
     */
    public function GetFileContents(\StructType\GetFileContentsRequest $getFileContentsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFileContents($getFileContentsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFiles
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns an array of files
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFilesRequest $getFilesRequest
     * @return \StructType\GetFilesResponse|bool
     */
    public function GetFiles(\StructType\GetFilesRequest $getFilesRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFiles($getFilesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGuests
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Gets a list of guests
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGuestsRequest $getGuestsRequest
     * @return \StructType\GetGuestsResponse|bool
     */
    public function GetGuests(\StructType\GetGuestsRequest $getGuestsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetGuests($getGuestsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGuestSocialNetworks
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns a list of social network(s) for the guest.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGuestSocialNetworksRequest $getGuestSocialNetworksRequest
     * @return \StructType\GetGuestSocialNetworksResponse|bool
     */
    public function GetGuestSocialNetworks(\StructType\GetGuestSocialNetworksRequest $getGuestSocialNetworksRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetGuestSocialNetworks($getGuestSocialNetworksRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetItemCountryRegion
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns item, country and region properties along with taxings for an item.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetItemCountryRegionRequest $getItemCountryRegionRequest
     * @return \StructType\GetItemCountryRegionResponse|bool
     */
    public function GetItemCountryRegion(\StructType\GetItemCountryRegionRequest $getItemCountryRegionRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetItemCountryRegion($getItemCountryRegionRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetItems
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns price, volume, and description for one or more item codes.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetItemsRequest $getItemsRequest
     * @return \StructType\GetItemsResponse|bool
     */
    public function GetItems(\StructType\GetItemsRequest $getItemsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetItems($getItemsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLoginSession
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Deprecated. Use AuthenticateCustomer instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLoginSessionRequest $getLoginSessionRequest
     * @return \StructType\GetLoginSessionResponse|bool
     */
    public function GetLoginSession(\StructType\GetLoginSessionRequest $getLoginSessionRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLoginSession($getLoginSessionRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrders
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns one or more orders. You can submit several optional filter fields to control the results.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrdersRequest $getOrdersRequest
     * @return \StructType\GetOrdersResponse|bool
     */
    public function GetOrders(\StructType\GetOrdersRequest $getOrdersRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOrders($getOrdersRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderTotals
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns the totals of accepted orders within a date range
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderTotalsRequest $getOrderTotalsRequest
     * @return \StructType\GetOrderTotalsResponse|bool
     */
    public function GetOrderTotals(\StructType\GetOrderTotalsRequest $getOrderTotalsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOrderTotals($getOrderTotalsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetParties
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Gets Parties list
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPartiesRequest $getPartiesRequest
     * @return \StructType\GetPartiesResponse|bool
     */
    public function GetParties(\StructType\GetPartiesRequest $getPartiesRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetParties($getPartiesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPartyGuests
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Gets a list of guests belonging to a party
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPartyGuestsRequest $getPartyGuestsRequest
     * @return \StructType\GetPartyGuestsResponse|bool
     */
    public function GetPartyGuests(\StructType\GetPartyGuestsRequest $getPartyGuestsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPartyGuests($getPartyGuestsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPayments
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Gets payment record(s) for a customer or order.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPaymentsRequest $getPaymentsRequest
     * @return \StructType\GetPaymentsResponse|bool
     */
    public function GetPayments(\StructType\GetPaymentsRequest $getPaymentsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPayments($getPaymentsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPointAccount
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Get the balance of a point account for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPointAccountRequest $getPointAccountRequest
     * @return \StructType\GetPointAccountResponse|bool
     */
    public function GetPointAccount(\StructType\GetPointAccountRequest $getPointAccountRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPointAccount($getPointAccountRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQualificationOverrides
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns Customer Overrides
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQualificationOverridesRequest $getQualificationOverridesRequest
     * @return \StructType\GetQualitificationOverridesResponse|bool
     */
    public function GetQualificationOverrides(\StructType\GetQualificationOverridesRequest $getQualificationOverridesRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetQualificationOverrides($getQualificationOverridesRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRandomMessage
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Gets a random message (defined in the Exigo Admin).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRandomMessageRequest $getRandomMessageRequest
     * @return \StructType\GetRandomMessageResponse|bool
     */
    public function GetRandomMessage(\StructType\GetRandomMessageRequest $getRandomMessageRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRandomMessage($getRandomMessageRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRankQualifications
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns rank qualification report card.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRankQualificationsRequest $getRankQualificationsRequest
     * @return \StructType\GetRankQualificationsResponse|bool
     */
    public function GetRankQualifications(\StructType\GetRankQualificationsRequest $getRankQualificationsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRankQualifications($getRankQualificationsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRealTimeCommissionDetail
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns realtime commission detail for a customer/bonus.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRealTimeCommissionDetailRequest $getRealTimeCommissionDetailRequest
     * @return \StructType\GetRealTimeCommissionDetailResponse|bool
     */
    public function GetRealTimeCommissionDetail(\StructType\GetRealTimeCommissionDetailRequest $getRealTimeCommissionDetailRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRealTimeCommissionDetail($getRealTimeCommissionDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRealTimeCommissions
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns realtime commissions available for open periods.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRealTimeCommissionsRequest $getRealTimeCommissionsRequest
     * @return \StructType\GetRealTimeCommissionsResponse|bool
     */
    public function GetRealTimeCommissions(\StructType\GetRealTimeCommissionsRequest $getRealTimeCommissionsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRealTimeCommissions($getRealTimeCommissionsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReport
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns a custom report in dataset format.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReportRequest $getReportRequest
     * @return \StructType\GetReportResponse|bool
     */
    public function GetReport(\StructType\GetReportRequest $getReportRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetReport($getReportRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCommissionReport
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns a commission report in json format.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCommissionReportRequest $getCommissionReportRequest
     * @return \StructType\GetCommissionReportResponse|bool
     */
    public function GetCommissionReport(\StructType\GetCommissionReportRequest $getCommissionReportRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCommissionReport($getCommissionReportRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSandbox
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Get List of Sandboxes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSandboxRequest $getSandboxRequest
     * @return \StructType\GetSandboxResponse|bool
     */
    public function GetSandbox(\StructType\GetSandboxRequest $getSandboxRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSandbox($getSandboxRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSession
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Gets a generic session string for a unique sessionID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSessionRequest $getSessionRequest
     * @return \StructType\GetSessionResponse|bool
     */
    public function GetSession(\StructType\GetSessionRequest $getSessionRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSession($getSessionRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetShipMethods
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: This has been deprecated. Use CalculateOrder with ReturnShipMethods=true instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShipMethodsRequest $getShipMethodsRequest
     * @return \StructType\GetShipMethodsResponse|bool
     */
    public function GetShipMethods(\StructType\GetShipMethodsRequest $getShipMethodsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetShipMethods($getShipMethodsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetShoppingCart
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Gets a existing Shopping Cart Session.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShoppingCartRequest $getShoppingCartRequest
     * @return \StructType\GetShoppingCartResponse|bool
     */
    public function GetShoppingCart(\StructType\GetShoppingCartRequest $getShoppingCartRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetShoppingCart($getShoppingCartRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSubscription
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Get the subscription account for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSubscriptionRequest $getSubscriptionRequest
     * @return \StructType\GetSubscriptionResponse|bool
     */
    public function GetSubscription(\StructType\GetSubscriptionRequest $getSubscriptionRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSubscription($getSubscriptionRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUpline
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Gets nodes in an upline.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUplineRequest $getUplineRequest
     * @return \StructType\GetUplineResponse|bool
     */
    public function GetUpline(\StructType\GetUplineRequest $getUplineRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUpline($getUplineRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserPermissions
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: ApiAuthentication
     * - SOAPHeaderNamespaces: http://api.exigo.com/
     * - SOAPHeaderTypes: \StructType\ApiAuthentication
     * - SOAPHeaders: required
     * - documentation: Returns permissions associated with the corporate user account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserPermissionsRequest $getUserPermissionsRequest
     * @return \StructType\GetUserPermissionsResponse|bool
     */
    public function GetUserPermissions(\StructType\GetUserPermissionsRequest $getUserPermissionsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUserPermissions($getUserPermissionsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAccountDirectDepositResponse|\StructType\GetApiWhitelistResponse|\StructType\GetAutoOrdersResponse|\StructType\GetBinaryPreferenceResponse|\StructType\GetCommissionReportResponse|\StructType\GetCompanyNewsItemResponse|\StructType\GetCompanyNewsResponse|\StructType\GetCountryRegionsResponse|\StructType\GetCustomerBalancesResponse|\StructType\GetCustomerBillingResponse|\StructType\GetCustomerExtendedResponse|\StructType\GetCustomerLeadSocialNetworksResponse|\StructType\GetCustomerLeadsResponse|\StructType\GetCustomerNotesResponse|\StructType\GetCustomerSiteResponse|\StructType\GetCustomerSocialNetworksResponse|\StructType\GetCustomersResponse|\StructType\GetCustomerWallResponse|\StructType\GetCustomReportResponse|\StructType\GetDownlineResponse|\StructType\GetEmailAttachmentResponse|\StructType\GetEntityResponse|\StructType\GetFileContentsResponse|\StructType\GetFilesResponse|\StructType\GetGuestSocialNetworksResponse|\StructType\GetGuestsResponse|\StructType\GetItemCountryRegionResponse|\StructType\GetItemsResponse|\StructType\GetLanguagesResponse|\StructType\GetLoginSessionResponse|\StructType\GetOrderInvoiceResponse|\StructType\GetOrdersResponse|\StructType\GetOrderTotalsResponse|\StructType\GetPartiesResponse|\StructType\GetPartyGuestsResponse|\StructType\GetPaymentsResponse|\StructType\GetPointAccountResponse|\StructType\GetQualitificationOverridesResponse|\StructType\GetRandomMessageResponse|\StructType\GetRankQualificationsResponse|\StructType\GetRealTimeCommissionDetailResponse|\StructType\GetRealTimeCommissionsResponse|\StructType\GetReportResponse|\StructType\GetSandboxResponse|\StructType\GetSchemaResponse|\StructType\GetSessionResponse|\StructType\GetShipMethodsResponse|\StructType\GetShoppingCartResponse|\StructType\GetSubscriptionResponse|\StructType\GetUplineResponse|\StructType\GetUserPermissionsResponse|\StructType\GetVolumesResponse|\StructType\GetWarehousesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
